/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugTransformationRunner;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMProvider;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachine;
import org.eclipse.osgi.util.NLS;

class VMInitializer
implements VMProvider {
    public static final int INITIALIZE_TIMEOUT = 60000;
    private final DebugTransformationRunner fRunner;
    private final ExecutionContext fExecContext;
    private final Object fLock = new Object();
    private Diagnostic fInitDiagnostic;
    private Thread fInitThread;
    private IQVTOVirtualMachineShell fVM;

    public VMInitializer(DebugTransformationRunner runner, ExecutionContext execContext) {
        if (runner == null || execContext == null) {
            throw new IllegalArgumentException();
        }
        this.fRunner = runner;
        this.fExecContext = execContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQVTOVirtualMachineShell getVM() throws CoreException {
        this.joinInitialization(60000L);
        Object object = this.fLock;
        synchronized (object) {
            if (this.fVM == null) {
                throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)this.fInitDiagnostic));
            }
        }
        return this.fVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackgrouInitialization() throws IllegalStateException {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fInitThread != null) {
                throw new IllegalStateException("Initialization already started");
            }
            this.fInitThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    VMInitializer.this.doInitialize();
                }
            });
        }
        this.fInitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinInitialization(long timeoutMilisec) throws CoreException {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fInitThread == null) {
                throw new IllegalStateException("Initialization not started");
            }
        }
        try {
            this.fInitThread.join(timeoutMilisec);
        }
        catch (InterruptedException e) {
            QVTODebugCore.log(e);
        }
        if (this.fInitThread.isAlive()) {
            throw new CoreException(QVTODebugCore.createStatus(4, NLS.bind((String)"QVTO VM initialization not finished in ({0}) ms", (Object)timeoutMilisec)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize() {
        Diagnostic diagnostic;
        QVTOVirtualMachine vm = null;
        try {
            diagnostic = this.fRunner.initialize();
            if (EmfUtilPlugin.isSuccess((Diagnostic)diagnostic)) {
                vm = new QVTOVirtualMachine(this.fRunner.createDebuggableAdapter(this.fExecContext));
            }
        }
        catch (Throwable e) {
            diagnostic = QvtPlugin.createErrorDiagnostic((String)"Unexpected exception caught", (Throwable)e);
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fInitDiagnostic = diagnostic;
            this.fVM = vm;
        }
    }
}

