/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackOverFlowError;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.stdlib.DictionaryImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.MutableListImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.ExceptionInstance;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationUtil {
    static final ISessionData.Entry<QvtOperationalEvaluationEnv> AGGREGATING_ROOT_ENV = new ISessionData.SimpleEntry<QvtOperationalEvaluationEnv>();

    private EvaluationUtil() {
    }

    public static QvtEvaluationResult createEvaluationResult(QvtOperationalEvaluationEnv mainEvalEnv) {
        TransformationInstance transfInstance = (TransformationInstance)mainEvalEnv.getValueOf("this");
        ArrayList<ModelExtentContents> extents = new ArrayList<ModelExtentContents>();
        OperationalTransformation transformation = transfInstance.getTransformation();
        for (ModelParameter modelParam : transformation.getModelParameter()) {
            ModelInstance model = transfInstance.getModel(modelParam);
            ModelExtentContents contents = model.getExtent().getContents();
            if (modelParam.getKind() == DirectionKind.IN || modelParam.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT/autoModelParam") != null) continue;
            extents.add(contents);
        }
        List<Object> outParamValues = transformation.isIsBlackbox() ? Collections.emptyList() : EvaluationUtil.makeOutParamValues(mainEvalEnv);
        ModelParameterExtent unboundExtent = mainEvalEnv.getAdapter(InternalEvaluationEnv.class).getUnboundExtent();
        return new QvtEvaluationResult(extents, unboundExtent.getRootObjects(), outParamValues);
    }

    private static List<Object> makeOutParamValues(QvtOperationalEvaluationEnv mainEvalEnv) {
        Object valueOf;
        MappingParameter mappingParam;
        ImperativeOperation entryPoint = mainEvalEnv.getOperation();
        ArrayList<Object> outParamValues = new ArrayList<Object>();
        for (EParameter param : mainEvalEnv.getOperation().getEParameters()) {
            mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() != DirectionKind.OUT || (valueOf = mainEvalEnv.getValueOf(mappingParam.getName())) == null) continue;
            outParamValues.add(valueOf);
        }
        for (EParameter param : entryPoint.getResult()) {
            mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() == DirectionKind.IN || (valueOf = mainEvalEnv.getValueOf(mappingParam.getName())) == null) continue;
            outParamValues.add(valueOf);
        }
        return outParamValues;
    }

    static void mapOperationOutAndResultParams(QvtOperationalEvaluationEnv sourceEnv, QvtOperationalEvaluationEnv targetEnv) {
        EParameter targetParam;
        EParameter sourceParam;
        ImperativeOperation sourceOper = sourceEnv.getOperation();
        ImperativeOperation targetOper = targetEnv.getOperation();
        EList sourceParams = sourceOper.getResult();
        EList targetParams = targetOper.getResult();
        if (sourceParams.size() != targetParams.size()) {
            throw new IllegalArgumentException("Source/Target environment operations have incompatible signatures");
        }
        int i = 0;
        while (i < sourceParams.size()) {
            sourceParam = (EParameter)sourceParams.get(i);
            targetParam = (EParameter)targetParams.get(i);
            targetEnv.copyVariableValueFrom(sourceEnv, sourceParam.getName(), targetParam.getName());
            ++i;
        }
        if (sourceParams.size() > 1) {
            targetEnv.copyVariableValueFrom(sourceEnv, "result", "result");
        }
        sourceParams = sourceOper.getEParameters();
        targetParams = targetOper.getEParameters();
        if (sourceParams.size() != targetParams.size()) {
            throw new IllegalArgumentException("Source/Target environment operations have incompatible signatures");
        }
        i = 0;
        while (i < sourceParams.size()) {
            sourceParam = (VarParameter)sourceParams.get(i);
            if (sourceParam.getKind() == DirectionKind.OUT) {
                targetParam = (EParameter)targetParams.get(i);
                targetEnv.copyVariableValueFrom(sourceEnv, sourceParam.getName(), targetParam.getName());
            }
            ++i;
        }
    }

    static Object formatLoggedElement(Object element) {
        if (element instanceof ExceptionInstance) {
            ExceptionInstance exception = (ExceptionInstance)element;
            return exception.toString();
        }
        return element;
    }

    static void checkCurrentStackDepth(QvtOperationalEvaluationEnv env) throws QvtStackOverFlowError {
        int depth = env.getDepth();
        if (depth >= env.getMaxStackDepth()) {
            InternalEvaluationEnv iternEnv = env.getAdapter(InternalEvaluationEnv.class);
            iternEnv.throwQVTException(new QvtStackOverFlowError("Stack depth: " + depth));
        }
    }

    static List<ModelInstance> getTransfromationModelArguments(QvtOperationalEvaluationEnv rootEnvironment, OperationalTransformation transformation) throws IllegalArgumentException {
        List<Object> args = rootEnvironment.getOperationArgs();
        ArrayList<ModelInstance> transformArgs = new ArrayList<ModelInstance>(args.size());
        for (Object nextArg : args) {
            if (nextArg instanceof ModelInstance) {
                transformArgs.add((ModelInstance)nextArg);
                continue;
            }
            throw new IllegalArgumentException("transformation requires arguments of ModelInstance type");
        }
        return transformArgs;
    }

    static Context createAggregatedContext(QvtOperationalEvaluationEnv evalEnv) {
        IContext parentContext = evalEnv.getContext();
        Context nestedContext = new Context();
        nestedContext.setLog(parentContext.getLog());
        nestedContext.setProgressMonitor(parentContext.getProgressMonitor());
        nestedContext.getTrace().setTraceContent(parentContext.getTrace().getTraceContent());
        nestedContext.setSessionData(parentContext.getSessionData());
        nestedContext.getSessionData().setValue(AGGREGATING_ROOT_ENV, evalEnv);
        Map<String, Object> configProps = parentContext.getConfigProperties();
        for (String propName : configProps.keySet()) {
            nestedContext.setConfigProperty(propName, configProps.get(propName));
        }
        return nestedContext;
    }

    public static QvtOperationalEvaluationEnv getAggregatingContext(QvtOperationalEvaluationEnv evalEnv) {
        return evalEnv.getContext().getSessionData().getValue(AGGREGATING_ROOT_ENV);
    }

    public static ImperativeOperation getOverridingOperation(QvtOperationalEvaluationEnv evalEnv, ImperativeOperation operation) {
        InternalEvaluationEnv internEvalEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        assert (internEvalEnv != null) : "must adapt to internal env";
        ModuleInstance currentInternModule = internEvalEnv.getCurrentModule();
        if (currentInternModule != null) {
            return currentInternModule.getAdapter(ModuleInstance.Internal.class).getOverridingOperation(operation);
        }
        return null;
    }

    public static <E> Collection<E> createNewCollectionOfSameKind(Collection<E> c) {
        Collection<Object> result = c instanceof MutableList ? new MutableListImpl() : (c instanceof Dictionary ? new DictionaryImpl() : CollectionUtil.createNewCollectionOfSameKind(c));
        return result;
    }

    public static <E> Collection<E> createNewCollection(CollectionType<EClassifier, EOperation> collectionType) {
        Collection<Object> result = null;
        if (collectionType instanceof ListType) {
            result = Utils.createList();
        } else if (collectionType instanceof DictionaryType) {
            result = Utils.createDictionary();
        } else {
            CollectionKind kind = collectionType.getKind();
            if (kind != null && kind != CollectionKind.COLLECTION_LITERAL) {
                result = CollectionUtil.createNewCollection((CollectionKind)collectionType.getKind());
            }
        }
        return result;
    }

    public static Object createInitialValue(EClassifier classifier, OCLStandardLibrary<EClassifier> oclstdlib, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evaluationEnv) {
        Tuple initialValue = null;
        if (classifier == oclstdlib.getString()) {
            initialValue = "";
        } else if (classifier == oclstdlib.getBoolean()) {
            initialValue = Boolean.FALSE;
        } else if (classifier == oclstdlib.getInteger()) {
            initialValue = Integer.valueOf(0);
        } else if (classifier == oclstdlib.getReal()) {
            initialValue = Double.valueOf(0.0);
        } else if (classifier == oclstdlib.getUnlimitedNatural()) {
            initialValue = Integer.valueOf(0);
        } else if (classifier instanceof CollectionType) {
            CollectionType collType = (CollectionType)classifier;
            initialValue = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)collType);
        } else if (classifier instanceof TupleType) {
            HashMap<EStructuralFeature, Object> propertyValues = new HashMap<EStructuralFeature, Object>();
            TupleType tupleType = (TupleType)classifier;
            for (EStructuralFeature feature : tupleType.oclProperties()) {
                propertyValues.put(feature, EvaluationUtil.createInitialValue(feature.getEType(), oclstdlib, evaluationEnv));
            }
            initialValue = evaluationEnv.createTuple((Object)classifier, propertyValues);
        }
        return initialValue;
    }

    public static Object doImplicitListCoercion(EClassifier declaredType, Object actualValue) {
        if (declaredType instanceof CollectionType && actualValue instanceof Collection) {
            if (declaredType instanceof ListType && !(actualValue instanceof MutableList)) {
                Collection newCollection = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)((CollectionType)declaredType));
                newCollection.addAll((Collection)actualValue);
                return newCollection;
            }
            if (declaredType instanceof SequenceType && actualValue instanceof MutableList) {
                Collection newCollection = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)((CollectionType)declaredType));
                newCollection.addAll((Collection)actualValue);
                return newCollection;
            }
        }
        return actualValue;
    }

    public static List<ModelParameter> getBlackboxSignature(OperationalTransformation transformation) {
        return transformation.getModelParameter();
    }

    public static boolean canContainNull(Collection<?> coll) {
        if (coll instanceof AbstractEList) {
            try {
                Method method = AbstractEList.class.getDeclaredMethod("canContainNull", new Class[0]);
                method.setAccessible(true);
                return (Boolean)method.invoke(coll, new Object[0]);
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }
}

