/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.ActualPartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.BasePartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractPartialRegionsAnalysis<@NonNull PRA extends PartialRegionsAnalysis<PRA>>
extends QVTbaseHelper
implements PartialRegionsAnalysis<PRA> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Map<@NonNull ClassDatum, @NonNull PartialRegionClassAnalysis<@NonNull PRA>> classDatum2classAnalysis = new HashMap<ClassDatum, PartialRegionClassAnalysis<PRA>>();
    protected final @NonNull Map<@NonNull PropertyDatum, @NonNull BasePartialRegionPropertyAnalysis<@NonNull PRA>> propertyDatum2basePropertyAnalysis = new HashMap<PropertyDatum, BasePartialRegionPropertyAnalysis<PRA>>();
    protected final @NonNull Map<@NonNull PropertyDatum, @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA>> propertyDatum2actualPropertyAnalysis = new HashMap<PropertyDatum, ActualPartialRegionPropertyAnalysis<PRA>>();

    protected AbstractPartialRegionsAnalysis(@NonNull ScheduleManager scheduleManager) {
        super(scheduleManager.getEnvironmentFactory());
        this.scheduleManager = scheduleManager;
    }

    @Override
    public @NonNull PartialRegionClassAnalysis<@NonNull PRA> addConsumer(@NonNull ClassDatum classDatum, @NonNull PartialRegionAnalysis<@NonNull PRA> consumer) {
        PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.lazyCreateClassAnalysis(classDatum);
        classAnalysis.addConsumer(consumer);
        return classAnalysis;
    }

    @Override
    public @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> addConsumer(@NonNull PropertyDatum propertyDatum, @NonNull PartialRegionAnalysis<@NonNull PRA> consumer) {
        ActualPartialRegionPropertyAnalysis<@NonNull PRA> propertyAnalysis = this.lazyCreatePropertyAnalysis(propertyDatum);
        propertyAnalysis.addConsumer(consumer);
        return propertyAnalysis;
    }

    @Override
    public @NonNull PartialRegionClassAnalysis<@NonNull PRA> addProducer(@NonNull ClassDatum classDatum, @NonNull PartialRegionAnalysis<@NonNull PRA> producer) {
        PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.lazyCreateClassAnalysis(classDatum);
        classAnalysis.addProducer(producer);
        return classAnalysis;
    }

    @Override
    public @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> addProducer(@NonNull PropertyDatum propertyDatum, @NonNull PartialRegionAnalysis<@NonNull PRA> producer) {
        ActualPartialRegionPropertyAnalysis<@NonNull PRA> propertyAnalysis = this.lazyCreatePropertyAnalysis(propertyDatum);
        propertyAnalysis.addProducer(producer);
        return propertyAnalysis;
    }

    public @Nullable PartialRegionClassAnalysis<@NonNull PRA> basicGetClassAnalysis(@NonNull ClassDatum classDatum) {
        return this.classDatum2classAnalysis.get(classDatum);
    }

    @Override
    public @Nullable ActualPartialRegionPropertyAnalysis<@NonNull PRA> basicGetPropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        return this.propertyDatum2actualPropertyAnalysis.get(propertyDatum);
    }

    protected void computeTraceClassDiscrimination() throws CompilerChainException {
        for (PartialRegionClassAnalysis<PRA> classAnalysis : this.classDatum2classAnalysis.values()) {
            classAnalysis.discriminate();
        }
    }

    public void computeTraceClassInheritance() {
        PartialRegionClassAnalysis<Object> superClassRegionAnalysis;
        ClassDatum classDatum;
        HashSet<@NonNull ClassDatum> missingClassDatums = new HashSet<ClassDatum>();
        for (PartialRegionClassAnalysis<PRA> partialRegionClassAnalysis : this.classDatum2classAnalysis.values()) {
            classDatum = partialRegionClassAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum || (superClassRegionAnalysis = this.classDatum2classAnalysis.get(superClassDatum)) != null) continue;
                missingClassDatums.add(superClassDatum);
            }
        }
        for (ClassDatum classDatum2 : missingClassDatums) {
            this.lazyCreateClassAnalysis(classDatum2);
        }
        for (PartialRegionClassAnalysis<Object> partialRegionClassAnalysis : this.classDatum2classAnalysis.values()) {
            classDatum = partialRegionClassAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum) continue;
                superClassRegionAnalysis = this.classDatum2classAnalysis.get(superClassDatum);
                assert (superClassRegionAnalysis != null);
                superClassRegionAnalysis.addSubClassAnalysis(partialRegionClassAnalysis);
                partialRegionClassAnalysis.addSuperClassAnalysis(superClassRegionAnalysis);
            }
        }
    }

    protected abstract @NonNull PartialRegionClassAnalysis<@NonNull PRA> createClassAnalysis(@NonNull ClassDatum var1);

    protected @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> createPropertyAnalysis(@NonNull PartialRegionClassAnalysis<@NonNull PRA> classAnalysis, @NonNull PropertyDatum propertyDatum) {
        ActualPartialRegionPropertyAnalysis<@NonNull PRA> propertyAnalysis = this.propertyDatum2actualPropertyAnalysis.get(propertyDatum);
        assert (propertyAnalysis == null);
        PropertyDatum basePropertyDatum = this.scheduleManager.getBasePropertyDatum(propertyDatum);
        BasePartialRegionPropertyAnalysis<@NonNull PRA> basePropertyAnalysis = this.propertyDatum2basePropertyAnalysis.get(basePropertyDatum);
        if (basePropertyAnalysis == null) {
            ClassDatum baseClassDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)basePropertyDatum);
            PartialRegionClassAnalysis<@NonNull PRA> baseClassAnalysis = this.lazyCreateClassAnalysis(baseClassDatum);
            basePropertyAnalysis = new BasePartialRegionPropertyAnalysis<PRA>(this, baseClassAnalysis, basePropertyDatum);
            this.propertyDatum2basePropertyAnalysis.put(basePropertyDatum, basePropertyAnalysis);
        }
        propertyAnalysis = basePropertyAnalysis.createPropertyAnalysis(classAnalysis, propertyDatum);
        this.propertyDatum2actualPropertyAnalysis.put(propertyDatum, propertyAnalysis);
        return propertyAnalysis;
    }

    @Override
    public @NonNull PartialRegionClassAnalysis<@NonNull PRA> getClassAnalysis(@NonNull ClassDatum classDatum) {
        return (PartialRegionClassAnalysis)ClassUtil.nonNullState(this.classDatum2classAnalysis.get(classDatum));
    }

    @Override
    public @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> getPropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        return (ActualPartialRegionPropertyAnalysis)ClassUtil.nonNullState(this.propertyDatum2actualPropertyAnalysis.get(propertyDatum));
    }

    @Override
    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    private @NonNull PartialRegionClassAnalysis<@NonNull PRA> lazyCreateClassAnalysis(@NonNull ClassDatum classDatum) {
        PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.classDatum2classAnalysis.get(classDatum);
        if (classAnalysis == null) {
            classAnalysis = this.createClassAnalysis(classDatum);
            this.classDatum2classAnalysis.put(classDatum, classAnalysis);
        }
        return classAnalysis;
    }

    private @NonNull ActualPartialRegionPropertyAnalysis<@NonNull PRA> lazyCreatePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        ActualPartialRegionPropertyAnalysis<@NonNull PRA> propertyAnalysis = this.propertyDatum2actualPropertyAnalysis.get(propertyDatum);
        if (propertyAnalysis == null) {
            ClassDatum classDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)propertyDatum);
            PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.lazyCreateClassAnalysis(classDatum);
            propertyAnalysis = this.createPropertyAnalysis(classAnalysis, propertyDatum);
        }
        return propertyAnalysis;
    }
}

