/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.graphs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.ToGraphHelper;

public class GraphMLStringBuilder
extends GraphMLBuilder
implements GraphStringBuilder {
    private static final @NonNull Map<String, String> colorName2colorCode = new HashMap<String, String>();
    private final @NonNull Map<@Nullable Object, @NonNull Map<@NonNull Object, @NonNull String>> scope2node2name = new HashMap<Object, Map<Object, String>>();
    private @NonNull Map<@NonNull Object, @NonNull String> node2name;
    private int nameCount = 0;
    private int graphCount = 0;
    private @NonNull String color = "#cccccc";
    private @NonNull String fillColor = "#ffffff";
    private @Nullable String label = null;
    private @NonNull String penwidth = "2.0";
    private @NonNull String shape = "rectangle";
    private @NonNull GraphMLBuilder.LineType lineType = GraphMLBuilder.LineType.line;
    private @NonNull String labelColor = "#000000";
    private @Nullable GraphMLBuilder.ArrowType sourceArrowType = null;
    private @Nullable String sourceLabel = null;
    private @Nullable GraphMLBuilder.ArrowType targetArrowType = null;
    private @Nullable String targetLabel = null;

    static {
        colorName2colorCode.put("black", "#000000");
        colorName2colorCode.put("brown", "#993300");
        colorName2colorCode.put("blue", "#0000ff");
        colorName2colorCode.put("cyan", "#00ffff");
        colorName2colorCode.put("darkorange", "#ffcc00");
        colorName2colorCode.put("gray", "#cccccc");
        colorName2colorCode.put("green", "#00ff00");
        colorName2colorCode.put("green3", "#00ff00");
        colorName2colorCode.put("lightblue1", "#ccccff");
        colorName2colorCode.put("lightcyan1", "#ccffff");
        colorName2colorCode.put("lightgray", "#dddddd");
        colorName2colorCode.put("magenta", "#ff00ff");
        colorName2colorCode.put("orange", "#ffcc00");
        colorName2colorCode.put("palegreen1", "#ccffcc");
        colorName2colorCode.put("palegoldenrod", "#ffeecc");
        colorName2colorCode.put("pink1", "#ffcccc");
        colorName2colorCode.put("red", "#ff0000");
        colorName2colorCode.put("white", "#ffffff");
        colorName2colorCode.put("yellow", "#ffff00");
    }

    public GraphMLStringBuilder() {
        this.node2name = new HashMap<Object, String>();
        this.scope2node2name.put(null, this.node2name);
        this.open();
    }

    @Override
    public void appendAttributedEdge(@NonNull String sourceName, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull String targetName) {
        String sourceId = sourceName;
        String targetId = targetName;
        String lineColor = this.color;
        Double width = Double.valueOf(this.penwidth);
        this.s.pushTag("edge");
        this.appendEdgeId();
        this.appendEdgeSource(sourceId);
        this.appendEdgeTarget(targetId);
        this.s.pushTag("data");
        this.s.appendElement("key", "d9");
        this.s.pushTag("y:PolyLineEdge");
        this.appendLineStyle(new GraphMLBuilder.LineStyle(this, lineColor, this.lineType, width));
        this.appendArrows(this.sourceArrowType != null ? this.sourceArrowType.name() : GraphMLBuilder.ArrowType.none.name(), this.targetArrowType != null ? this.targetArrowType.name() : GraphMLBuilder.ArrowType.delta.name());
        this.appendEdgeLabel(this.sourceLabel, this.labelColor, this.targetLabel);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
        this.resetAttributes();
    }

    @Override
    public void appendAttributedNode(@NonNull String nodeName) {
        String id = nodeName;
        String shapeName = this.shape;
        String lineColor = this.color;
        Double width = Double.valueOf(this.penwidth);
        this.s.pushTag("node");
        this.s.appendElement("id", "n" + id);
        this.appendData("d5");
        this.s.pushTag("data");
        this.s.appendElement("key", "d6");
        this.s.pushTag("y:ShapeNode");
        GraphMLBuilder.Geometry g = new GraphMLBuilder.Geometry(this);
        g.adjustToText(this.label, 12, shapeName);
        this.appendGeometry(g);
        this.appendFill(this.fillColor);
        this.appendBorder(new GraphMLBuilder.BorderStyle(this, lineColor, this.lineType, width));
        this.appendNodeLabel(this.label, this.labelColor);
        this.appendShape(shapeName);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
        this.resetAttributes();
    }

    @Override
    public void appendEdge(@NonNull ToGraphHelper toGraphHelper, @NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
        String sourceName = this.appendNode(toGraphHelper, source);
        String targetName = this.appendNode(toGraphHelper, target);
        this.resetAttributes();
        edge.appendEdgeAttributes(toGraphHelper, sourceName, targetName);
        this.resetAttributes();
    }

    @Override
    public @NonNull String appendNode(@NonNull ToGraphHelper toGraphHelper, @NonNull GraphStringBuilder.GraphNode object) {
        String name = this.node2name.get(object);
        if (name == null) {
            Map<@NonNull Object, @NonNull String> globalNode2Name = this.scope2node2name.get(null);
            assert (globalNode2Name != null);
            name = globalNode2Name.get(object);
        }
        if (name == null) {
            name = "a" + ++this.nameCount;
            this.node2name.put(object, name);
            this.resetAttributes();
            object.appendNode(toGraphHelper, name);
        }
        return name;
    }

    @Override
    public void popCluster() {
        this.s.popTag();
        this.s.popTag();
    }

    @Override
    public void pushCluster() {
        this.s.pushTag("node");
        this.s.appendElement("id", "gn" + this.graphCount++);
        this.appendData("d5");
        this.s.pushTag("data");
        this.s.appendElement("key", "d6");
        this.s.pushTag("y:ShapeNode");
        this.appendFill("#ffffff");
        this.s.appendTextBegin("y:NodeLabel");
        this.s.appendElement("fontSize", "16");
        this.s.appendElement("modelName", "sides");
        this.s.appendElement("modelPosition", "n");
        if (this.label == null) {
            this.getClass();
        }
        this.s.appendTextEnd(this.label);
        this.s.popTag();
        this.s.popTag();
        this.s.pushTag("graph");
        this.s.appendElement("id", "gg" + this.graphCount++);
        this.s.appendElement("edgedefault", "directed");
    }

    protected void resetAttributes() {
        this.color = "#000000";
        this.fillColor = "#ffffff";
        this.label = null;
        this.sourceLabel = null;
        this.targetLabel = null;
        this.lineType = GraphMLBuilder.LineType.line;
        this.penwidth = "2.0";
        this.shape = "rectangle";
        this.sourceArrowType = null;
        this.targetArrowType = null;
    }

    @Override
    public void setArrowhead(@NonNull String arrowhead) {
        if ("diamond".equals(arrowhead)) {
            this.targetArrowType = GraphMLBuilder.ArrowType.diamond;
        } else if ("none".equals(arrowhead)) {
            this.targetArrowType = GraphMLBuilder.ArrowType.none;
        } else if ("normal".equals(arrowhead)) {
            this.targetArrowType = GraphMLBuilder.ArrowType.delta;
        } else if ("odiamond".equals(arrowhead)) {
            this.targetArrowType = GraphMLBuilder.ArrowType.white_diamond;
        } else if ("vee".equals(arrowhead)) {
            this.targetArrowType = GraphMLBuilder.ArrowType.standard;
        }
    }

    @Override
    public void setArrowtail(@NonNull String arrowtail) {
        if ("diamond".equals(arrowtail)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.diamond;
        } else if ("none".equals(arrowtail)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.none;
        } else if ("normal".equals(arrowtail)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.delta;
        } else if ("odiamond".equals(arrowtail)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.white_diamond;
        } else if ("vee".equals(arrowtail)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.standard;
        }
    }

    @Override
    public void setColor(@NonNull String colorName) {
        String colorCode = colorName2colorCode.get(colorName);
        this.color = colorCode != null ? colorCode : "#777777";
    }

    @Override
    public void setDir(@NonNull String direction) {
    }

    @Override
    public void setFillColor(@NonNull String colorName) {
        String colorCode = colorName2colorCode.get(colorName);
        this.fillColor = colorCode != null ? colorCode : "#777777";
    }

    @Override
    public void setHead() {
    }

    @Override
    public void setHeadlabel(String label) {
        String replace = "  " + label.replace("\\n", "  \n  ") + "  ";
        if (replace.length() < 10) {
            replace = "   " + replace + "    ";
        }
        this.sourceLabel = replace;
    }

    @Override
    public void setLabel(String label) {
        String replace = "  " + label.replace("\\n", "  \n  ") + "  ";
        if (replace.length() < 10) {
            replace = "   " + replace + "    ";
        }
        this.label = replace;
    }

    @Override
    public void setPenwidth(@NonNull Integer penwidth) {
        this.penwidth = penwidth.toString();
    }

    @Override
    public void setScope(@Nullable Object scopeObject) {
        Map<@NonNull Object, @NonNull String> entry = this.scope2node2name.get(scopeObject);
        if (entry == null) {
            entry = new HashMap<Object, String>();
            this.scope2node2name.put(scopeObject, entry);
        }
        this.node2name = entry;
    }

    @Override
    public void setShape(@NonNull String shape) {
        this.shape = shape;
    }

    @Override
    public void setStyle(@NonNull String style) {
        if (style.indexOf("dashed") >= 0) {
            this.lineType = GraphMLBuilder.LineType.dashed;
        } else if (style.indexOf("dotted") >= 0) {
            this.lineType = GraphMLBuilder.LineType.dotted;
        }
        if ("rectangle".equals(this.shape) && style.indexOf("rounded") >= 0) {
            this.shape = GraphMLBuilder.ShapeType.roundrectangle.toString();
        }
    }

    @Override
    public void setTaillabel(String label) {
        String replace = "  " + label.replace("\\n", "  \n  ") + "  ";
        if (replace.length() < 10) {
            replace = "   " + replace + "    ";
        }
        this.targetLabel = replace;
    }

    @Override
    public @NonNull String toString() {
        this.close();
        return super.toString();
    }
}

