/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractPartitionFactory<R extends Region>
extends RegionHelper<R>
implements PartitionFactory {
    protected AbstractPartitionFactory(@NonNull ScheduleManager scheduleManager, @NonNull R region) {
        super(scheduleManager, region);
    }

    protected void addEdge(@NonNull BasicPartition partition, @NonNull Edge edge, @NonNull Role newEdgeRole) {
        NavigationEdge oppositeEdge;
        assert (edge.getOwningRegion() == this.region);
        this.addEdge2(partition, edge, newEdgeRole);
        if (edge instanceof NavigationEdge && (oppositeEdge = ((NavigationEdge)edge).getOppositeEdge()) != null) {
            this.addEdge2(partition, (Edge)oppositeEdge, newEdgeRole);
        }
    }

    protected void addEdge2(@NonNull BasicPartition partition, @NonNull Edge edge, @NonNull Role newEdgeRole) {
        Role displacedEdgeRole = partition.putEdgeRole(edge, newEdgeRole);
        assert (displacedEdgeRole == null || displacedEdgeRole == newEdgeRole);
    }

    protected @NonNull ReachabilityForest createReachabilityForest() {
        return new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
    }

    protected abstract @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges();

    protected abstract @NonNull Iterable<@NonNull Node> getReachabilityRootNodes();

    protected @Nullable Role resolveCheckedEdgeRole(@NonNull Edge edge, @NonNull Role edgeRole) {
        return edgeRole;
    }

    protected abstract @Nullable Role resolveEdgeRole(@NonNull Role var1, @NonNull Edge var2, @NonNull Role var3);

    protected void resolveEdges(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        Role edgeRole;
        Role targetNodeRole;
        Role sourceNodeRole;
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        ReachabilityForest reachabilityForest = partitionAnalysis.getReachabilityForest();
        HashSet<@NonNull Edge> reachingEdges = new HashSet<Edge>();
        for (Node node : partition.getPartialNodes()) {
            Edge reachingEdge = reachabilityForest.getReachingEdge(node);
            if (reachingEdge == null) continue;
            reachingEdges.add(reachingEdge);
            if (partition.hasEdge(reachingEdge) || (sourceNodeRole = partition.getRole(reachingEdge.getEdgeSource())) == null || (targetNodeRole = partition.getRole(reachingEdge.getEdgeTarget())) == null || (edgeRole = this.resolveEdgeRole(sourceNodeRole, reachingEdge, targetNodeRole)) == null) continue;
            if (edgeRole == Role.REALIZED) {
                edgeRole = this.resolveReachingEdgeRole(partition, reachingEdges, reachingEdge, edgeRole);
            }
            if (edgeRole == null) continue;
            this.addEdge(partition, reachingEdge, edgeRole);
        }
        for (Node node : partition.getPartialNodes()) {
            Edge edge2;
            if (node.isOperation()) {
                for (Edge edge2 : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Role edgeRole2;
                    Role targetNodeRole2;
                    Role sourceNodeRole2;
                    if (!edge2.isExpression() && !edge2.isNavigation() || partition.hasEdge(edge2) || (sourceNodeRole2 = partition.getRole(edge2.getEdgeSource())) == null || (targetNodeRole2 = partition.getRole(edge2.getEdgeTarget())) == null || (edgeRole2 = this.resolveEdgeRole(sourceNodeRole2, edge2, targetNodeRole2)) == null) continue;
                    if (edgeRole2 == Role.REALIZED) {
                        edgeRole2 = this.resolveReachingEdgeRole(partition, reachingEdges, edge2, edgeRole2);
                    }
                    if (edgeRole2 == null) continue;
                    this.addEdge(partition, edge2, edgeRole2);
                }
                continue;
            }
            edge2 = reachabilityForest.getReachingEdge(node);
            if (edge2 == null || partition.hasEdge(edge2)) continue;
            assert (!partition.hasEdge(edge2));
            sourceNodeRole = partition.getRole(edge2.getEdgeSource());
            if (sourceNodeRole == null || (targetNodeRole = partition.getRole(edge2.getEdgeTarget())) == null || (edgeRole = this.resolveEdgeRole(sourceNodeRole, edge2, targetNodeRole)) == null) continue;
            if (edgeRole == Role.REALIZED) {
                edgeRole = this.resolveReachingEdgeRole(partition, reachingEdges, edge2, edgeRole);
            }
            if (edgeRole == null) continue;
            this.addEdge(partition, edge2, edgeRole);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            Role edgeRole3;
            Role targetNodeRole3;
            Role sourceNodeRole3;
            if (edge.isSecondary() || partition.hasEdge(edge) || (sourceNodeRole3 = partition.getRole(edge.getEdgeSource())) == null || (targetNodeRole3 = partition.getRole(edge.getEdgeTarget())) == null || (edgeRole3 = this.resolveEdgeRole(sourceNodeRole3, edge, targetNodeRole3)) == null || (edgeRole3 = edgeRole3 == Role.REALIZED ? this.resolveReachingEdgeRole(partition, reachingEdges, edge, edgeRole3) : this.resolveCheckedEdgeRole(edge, edgeRole3)) == null) continue;
            this.addEdge(partition, edge, edgeRole3);
        }
    }

    protected @Nullable Role resolveReachingEdgeRole(@NonNull BasicPartition partition, @NonNull Set<@NonNull Edge> reachingEdges, @NonNull Edge edge, @NonNull Role edgeRole) {
        return edgeRole;
    }
}

