/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.SimpleConnection;
import org.eclipse.qvtd.runtime.evaluation.SimpleIncrementalConnection;
import org.eclipse.qvtd.runtime.evaluation.StrictConnection;
import org.eclipse.qvtd.runtime.evaluation.StrictIncrementalConnection;

public interface ModeFactory {
    public static final @NonNull ModeFactory INCREMENTAL = new Incremental();
    public static final @NonNull ModeFactory NON_INCREMENTAL = new NonIncremental();

    public @NonNull Connection createConnection(@NonNull Interval var1, @NonNull String var2, @NonNull TypeId var3, boolean var4);

    public static class Incremental
    implements ModeFactory {
        @Override
        public @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            if (isStrict) {
                return new StrictIncrementalConnection(interval, name, typeId);
            }
            return new SimpleIncrementalConnection(interval, name, typeId);
        }
    }

    public static class NonIncremental
    implements ModeFactory {
        @Override
        public @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            if (isStrict) {
                return new StrictConnection(interval, name, typeId);
            }
            return new SimpleConnection(interval, name, typeId);
        }
    }
}

