/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.environment;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistryPackage;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelResolver;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.model.ModelNameAccessor;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.ProjectRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.model.URIAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModelResolver
implements ModelResolver {
    private final AbstractFileHandle handle;
    private ResourceSet resourceSet = null;
    private ProjectRegistry projectRegistry = null;

    public AbstractModelResolver(AbstractFileHandle handle) {
        this.handle = handle;
        this.resourceSet = null;
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    @Override
    public AbstractFileHandle getHandle() {
        return this.handle;
    }

    protected EPackage[] getPackagesToRegister() {
        return new EPackage[]{ModelRegistryPackage.eINSTANCE};
    }

    @Override
    public ProjectRegistry getProjectRegistry() {
        if (this.projectRegistry == null) {
            AbstractProjectHandle projectHandle = this.handle.getProjectHandle();
            this.projectRegistry = new ProjectRegistry(projectHandle, this.getResourceSet());
            this.projectRegistry.loadModel();
        }
        return this.projectRegistry;
    }

    public <A extends Accessor> Registration<A> getRegistration(A accessor) {
        return this.getProjectRegistry().getRegistration(this.handle, accessor);
    }

    public Registration<ModelNameAccessor> getRegistration(String modelName) {
        ModelNameAccessor accessor = new ModelNameAccessor(modelName);
        return this.getRegistration(accessor);
    }

    public Registration<URIAccessor> getRegistration(java.net.URI uri) {
        URIAccessor accessor = new URIAccessor(uri);
        return this.getRegistration(accessor);
    }

    public <A extends Accessor> Collection<Registration<A>> getRegistrations(Class<A> accessorClass) {
        return this.getProjectRegistry().getRegistrations(this.handle, accessorClass);
    }

    @Override
    public Resource getResource(URI uri, boolean loadOnDemand) throws Exception {
        try {
            return this.resourceSet.getResource(uri, loadOnDemand);
        }
        catch (WrappedException e) {
            throw e.exception();
        }
    }

    public Resource getResource(Registration<ModelNameAccessor> registration) throws IOException {
        if (registration == null) {
            return null;
        }
        URI rawURI = registration.getURI();
        URI resolvedURI = this.getProjectRegistry().resolveURI(rawURI);
        ModelSerialization serialization = registration.getSerialization();
        ModelSerializationRegistry serializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        ModelSerializationRegistry.FactorySerializationDelegate serializationDelegate = serializationRegistry.getSerialization(serialization.getName());
        if (serializationDelegate == null) {
            return null;
        }
        Resource.Factory serializationFactory = (Resource.Factory)serializationDelegate.load();
        if (serializationFactory == null) {
            return null;
        }
        Resource resource = this.getResourceSet().getResource(resolvedURI, false);
        if (resource == null) {
            resource = serializationFactory.createResource(resolvedURI);
        }
        if (resource == null) {
            return null;
        }
        this.getResourceSet().getResources().add((Object)resource);
        resource.load(null);
        return resource;
    }

    @Override
    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.setResourceSet(this.initialiseResourceSet(this.createResourceSet()));
        }
        return this.resourceSet;
    }

    @Override
    public URI getURI(Accessor accessor) {
        return this.getProjectRegistry().getResolvedURI(this.handle, accessor);
    }

    @Override
    public URI getURI(String modelName) {
        ModelNameAccessor accessor = new ModelNameAccessor(modelName);
        return this.getURI(accessor);
    }

    @Override
    public URI getURI(java.net.URI uri) {
        URIAccessor accessor = new URIAccessor(uri);
        return this.getURI(accessor);
    }

    protected void initialiseResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        resourceFactoryRegistry.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    protected ResourceSet initialiseResourceSet(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        EPackage[] ePackages = this.getPackagesToRegister();
        if (ePackages != null) {
            EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
            EPackage[] ePackageArray = ePackages;
            int n = ePackages.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                ++n2;
            }
        }
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        this.initialiseResourceFactoryRegistry(resourceFactoryRegistry);
        return resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public String toString() {
        return this.handle.getProjectRelativeName();
    }
}

