/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.qvt.declarative.modelregistry.eclipse.ModelRegistryPlugin;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelContentRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.osgi.framework.Bundle;

public class ModelContentRegistryReader
extends RegistryReader {
    private static final String TAG_TEXT = "text";
    private static final String TAG_XML = "xml";
    private static final String ATT_ANALYSER = "analyser";
    private static final String ATT_FACTORY = "factory";
    private static final String ATT_URI = "uri";
    private final ModelContentRegistry modelContentRegistry;

    public ModelContentRegistryReader(ModelContentRegistry modelContentRegistry) {
        super(Platform.getExtensionRegistry(), ModelRegistryPlugin.getDefault().getBundle().getSymbolicName(), "model_content");
        this.modelContentRegistry = modelContentRegistry;
    }

    protected boolean readElement(IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        String namespaceIdentifier = extension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)namespaceIdentifier);
        if (element.getName().equals(TAG_TEXT)) {
            String analyserName = element.getAttribute(ATT_ANALYSER);
            if (analyserName == null) {
                ModelRegistryEnvironment.logError("Missing analyser for Text model content", null);
            } else {
                this.modelContentRegistry.addModelContentAnalyserDelegate(new BundleModelContentAnalyserDelegate(bundle, analyserName));
            }
            return true;
        }
        if (element.getName().equals(TAG_XML)) {
            String uri = element.getAttribute(ATT_URI);
            String factoryName = element.getAttribute(ATT_FACTORY);
            if (uri == null) {
                ModelRegistryEnvironment.logError("Missing URI for XML model content", null);
            } else if (factoryName == null) {
                ModelRegistryEnvironment.logError("Missing factory class for '" + uri + "' model content", null);
            } else {
                this.modelContentRegistry.addResourceFactoryDelegate(uri, new BundleResourceFactoryDelegate(bundle, factoryName));
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleModelContentAnalyserDelegate
    extends ModelContentRegistry.ModelContentAnalyserDelegate {
        protected final Bundle bundle;

        public BundleModelContentAnalyserDelegate(Bundle bundle, String name) {
            super(name);
            this.bundle = bundle;
        }

        @Override
        protected Class<?> loadClass(String className) throws ClassNotFoundException {
            return this.bundle.loadClass(className);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleResourceFactoryDelegate
    extends ModelContentRegistry.ResourceFactoryDelegate {
        protected final Bundle bundle;

        public BundleResourceFactoryDelegate(Bundle bundle, String name) {
            super(name);
            this.bundle = bundle;
        }

        @Override
        protected Class<?> loadClass(String className) throws ClassNotFoundException {
            return this.bundle.loadClass(className);
        }
    }
}

