/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class StreamUtils {
    private StreamUtils() {
    }

    public static String readStreamContents(IStreamContentAccessor sca) throws CoreException {
        InputStream is = sca.getContents();
        if (is != null) {
            String encoding = null;
            if (sca instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sca).getCharset();
                }
                catch (Exception exception) {}
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return StreamUtils.readStreamContents(is, encoding);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readStreamContents(InputStream is, String encoding) {
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                System.err.println("I/O Exception: " + ex.getMessage());
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static String readStreamContents(InputStream is) {
        return StreamUtils.readStreamContents(is, ResourcesPlugin.getEncoding());
    }
}

