/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.imp.core.IMPMessages;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.ui.ActionMessages;
import org.eclipse.imp.ui.explorer.OpenActionUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private UniversalEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
    }

    public OpenAction(UniversalEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof ISourceEntity || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!this.isProcessable()) {
            return;
        }
        ISourceEntity[] elements = null;
        if (elements == null || elements.length == 0) {
            IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
            }
            this.getShell().getDisplay().beep();
            return;
        }
        ISourceEntity element = elements[0];
        if (elements.length > 1 && (element = OpenActionUtil.selectJavaElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
            return;
        }
        if (element instanceof ISourceProject || element instanceof ISourceFolder) {
            element = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
        }
        this.run(new Object[]{element});
    }

    private boolean isProcessable() {
        ISourceEntity se = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
        if (this.fEditor != null) {
            if (se instanceof ICompilationUnit && !JavaModelUtil.isPrimary((ICompilationUnit)((ICompilationUnit)se))) {
                return true;
            }
        } else if (se instanceof IJavaElement) {
            return ActionUtil.isProcessable((Shell)this.getShell(), (IJavaElement)((IJavaElement)se));
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block9: {
                Object element = elements[i];
                try {
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof ISourceEntity) {
                        name = ((ISourceEntity)element).getName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block9;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)IMPMessages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{name, x.getMessage()}));
                }
            }
            ++i;
        }
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }
}

