/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.Util;

public class LocalAllocator
implements MethodData.Results {
    private static final String key = LocalAllocator.class.getName();
    private int nextLocal;

    LocalAllocator(MethodData info) {
        this.recalculateFrom(info);
    }

    private void recalculateFrom(MethodData info) {
        Instruction[] instructions = info.getInstructions();
        final int[] max = new int[]{Util.getParamsWordSize(info.getSignature()) + (info.getIsStatic() ? 0 : 1)};
        Instruction.Visitor visitor = new Instruction.Visitor(){

            public void visitLocalLoad(LoadInstruction instruction) {
                int v = instruction.getVarIndex() + Util.getWordSize(instruction.getType());
                if (v > max[0]) {
                    max[0] = v;
                }
            }

            public void visitLocalStore(StoreInstruction instruction) {
                int v = instruction.getVarIndex() + Util.getWordSize(instruction.getType());
                if (v > max[0]) {
                    max[0] = v;
                }
            }
        };
        int i = 0;
        while (i < instructions.length) {
            instructions[i].visit(visitor);
            ++i;
        }
        this.nextLocal = max[0];
    }

    private int allocateLocals(int count) {
        int r = this.nextLocal;
        this.nextLocal += count;
        return r;
    }

    public boolean notifyUpdate(MethodData info, Instruction[] newInstructions, ExceptionHandler[][] newHandlers, int[] newInstructionMap) {
        return false;
    }

    public static int allocate(MethodData info, int count) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        LocalAllocator l = (LocalAllocator)info.getInfo(key);
        if (l == null) {
            l = new LocalAllocator(info);
            info.putInfo(key, l);
        }
        return l.allocateLocals(count);
    }

    public static int allocate(MethodData info, String type) throws IllegalArgumentException {
        return LocalAllocator.allocate(info, type == null ? 2 : (int)Util.getWordSize(type));
    }

    public static int allocate(MethodData info) throws IllegalArgumentException {
        return LocalAllocator.allocate(info, null);
    }
}

