/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BagType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BooleanType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.IntegerType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OrderedSetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SequenceType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionType
extends OclAnyType {
    private static CollectionType instance;
    private static List<Operation> operations;
    protected OclAnyType parameterType;

    public CollectionType(OclAnyType parameter) {
        super(new OclType(CollectionType.computeName("Collection", parameter)));
        this.parameterType = parameter;
    }

    @Override
    public OclAnyType[] getSupertypes() {
        return new OclAnyType[]{OclAnyType.getInstance()};
    }

    public String getCollectionType() {
        return "Collection";
    }

    public OclAnyType getParameterType() {
        return this.parameterType;
    }

    @Override
    protected List<Operation> getTypeOperations() {
        if (operations == null) {
            operations = new ArrayList<Operation>(){
                {
                    this.add(new Operation("isEmpty", CollectionType.getInstance(), BooleanType.getInstance()));
                    this.add(new Operation("notEmpty", CollectionType.getInstance(), BooleanType.getInstance()));
                    this.add(new Operation("size", CollectionType.getInstance(), IntegerType.getInstance()));
                    this.add(new Operation("asSequence", (OclAnyType)CollectionType.getInstance(), null){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof CollectionType) {
                                CollectionType collection = (CollectionType)context;
                                return new SequenceType(collection.getParameterType());
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("asSet", (OclAnyType)CollectionType.getInstance(), null){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof CollectionType) {
                                CollectionType collection = (CollectionType)context;
                                return new SetType(collection.getParameterType());
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("asOrderedSet", (OclAnyType)CollectionType.getInstance(), null){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof CollectionType) {
                                CollectionType collection = (CollectionType)context;
                                return new OrderedSetType(collection.getParameterType());
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("asBag", (OclAnyType)CollectionType.getInstance(), null){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof CollectionType) {
                                CollectionType collection = (CollectionType)context;
                                return new BagType(collection.getParameterType());
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("flatten", (OclAnyType)CollectionType.getInstance(), null){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            OclAnyType type = context;
                            while (type instanceof CollectionType) {
                                type = ((CollectionType)type).getParameterType();
                            }
                            return new CollectionType(type);
                        }
                    });
                    this.add(new Operation("count", CollectionType.getInstance(), IntegerType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("o", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("sum", CollectionType.getInstance(), OclAnyType.getInstance()));
                    this.add(new Operation("includes", CollectionType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("o", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("excludes", CollectionType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("o", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("includesAll", CollectionType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("c", CollectionType.getInstance());
                        }
                    }));
                    this.add(new Operation("excludesAll", CollectionType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("c", CollectionType.getInstance());
                        }
                    }));
                    this.add(new Operation("excluding", CollectionType.getInstance(), null, (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("o", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("including", CollectionType.getInstance(), null, (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("o", OclAnyType.getInstance());
                        }
                    }));
                }
            };
        }
        return operations;
    }

    protected static String computeName(String collectionType, OclAnyType parameterType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(collectionType);
        buffer.append('(');
        buffer.append(parameterType.toString());
        buffer.append(')');
        return buffer.toString();
    }

    public static CollectionType getInstance() {
        if (instance == null) {
            instance = new CollectionType(OclAnyType.getInstance());
        }
        return instance;
    }
}

