/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.impl.FeatureImpl;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;

public class FieldImpl
extends FeatureImpl
implements Field {
    protected static final Object STATIC_VALUE_EDEFAULT = null;
    protected Object staticValue = STATIC_VALUE_EDEFAULT;
    protected CodeBlock initialiser;
    protected final Map<Object, Object> values = new HashMap<Object, Object>();
    protected boolean staticValueInitialised;

    protected FieldImpl() {
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.FIELD;
    }

    public Object getStaticValue() {
        return this.staticValue;
    }

    public void setStaticValue(Object newStaticValue) {
        Object oldStaticValue = this.staticValue;
        this.staticValue = newStaticValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldStaticValue, this.staticValue));
        }
    }

    public CodeBlock getInitialiser() {
        return this.initialiser;
    }

    public NotificationChain basicSetInitialiser(CodeBlock newInitialiser, NotificationChain msgs) {
        CodeBlock oldInitialiser = this.initialiser;
        this.initialiser = newInitialiser;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldInitialiser, (Object)newInitialiser);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setInitialiser(CodeBlock newInitialiser) {
        if (newInitialiser != this.initialiser) {
            NotificationChain msgs = null;
            if (this.initialiser != null) {
                msgs = ((InternalEObject)this.initialiser).eInverseRemove((InternalEObject)this, 9, CodeBlock.class, msgs);
            }
            if (newInitialiser != null) {
                msgs = ((InternalEObject)newInitialiser).eInverseAdd((InternalEObject)this, 9, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetInitialiser(newInitialiser, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newInitialiser, (Object)newInitialiser));
        }
    }

    public Rule getRule() {
        if (this.eContainerFeatureID() != 11) {
            return null;
        }
        return (Rule)this.eContainer();
    }

    public NotificationChain basicSetRule(Rule newRule, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newRule, 11, msgs);
        return msgs;
    }

    public void setRule(Rule newRule) {
        if (newRule != this.eInternalContainer() || this.eContainerFeatureID() != 11 && newRule != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newRule)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newRule != null) {
                msgs = ((InternalEObject)newRule).eInverseAdd((InternalEObject)this, 12, Rule.class, msgs);
            }
            if ((msgs = this.basicSetRule(newRule, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newRule, (Object)newRule));
        }
    }

    public Object getValue(Object context) {
        return this.values.get(context == null ? Void.TYPE : context);
    }

    public void setValue(Object context, Object value) {
        this.values.put(context == null ? Void.TYPE : context, value);
    }

    public Object getValue(Object context, StackFrame frame) {
        if (!this.values.containsKey(context == null ? Void.TYPE : context)) {
            this.checkFrame(context, frame);
            CodeBlock cb = this.getInitialiser();
            this.setValue(context, cb.execute(frame.getSubFrame(cb, context)).pop());
        }
        return this.getValue(context);
    }

    private void checkFrame(Object context, StackFrame frame) {
        CodeBlock initCb = this.getInitialiser();
        StackFrame newFrame = frame;
        while (newFrame != null) {
            if (newFrame.getCodeBlock() == initCb && newFrame.getLocal(0, 0) == context) {
                throw new VMException(newFrame, String.format("Infinite loop detected in field initialiser for %s.%s", context, this));
            }
            newFrame = newFrame.getParent();
        }
    }

    public Object getStaticValue(StackFrame frame) {
        if (!this.staticValueInitialised) {
            this.checkStaticFrame(frame);
            CodeBlock cb = this.getInitialiser();
            this.setStaticValue(cb.execute(new StackFrame(frame, cb)).pop());
            this.staticValueInitialised = true;
        }
        return this.getStaticValue();
    }

    public void clear() {
        this.staticValueInitialised = false;
        this.staticValue = null;
        this.values.clear();
    }

    public void addValue(Object context, Object value, int index, StackFrame frame) {
        Object currentVal = this.getValue(context, frame);
        if (currentVal instanceof Collection) {
            if (currentVal instanceof List) {
                if (value instanceof Collection) {
                    if (index > -1) {
                        ((List)currentVal).addAll(index, (Collection)value);
                    } else {
                        ((List)currentVal).addAll((Collection)value);
                    }
                } else if (index > -1) {
                    ((List)currentVal).add(index, value);
                } else {
                    ((List)currentVal).add(value);
                }
            } else {
                if (index > -1) {
                    throw new IllegalArgumentException(String.format("Cannot specify index for adding values to unordered collection field %s.%s", context, this));
                }
                if (value instanceof Collection) {
                    ((Collection)currentVal).addAll((Collection)value);
                } else {
                    ((Collection)currentVal).add(value);
                }
            }
        } else {
            if (currentVal != null) {
                throw new IllegalArgumentException(String.format("Cannot add more than one value to %s.%s", context, this));
            }
            if (index > 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.setValue(context, value);
        }
    }

    public void removeValue(Object context, Object value, StackFrame frame) {
        Object currentVal = this.getValue(context, frame);
        if (currentVal instanceof Collection) {
            if (value instanceof Collection) {
                ((Collection)currentVal).removeAll((Collection)value);
            } else {
                ((Collection)currentVal).remove(value);
            }
        } else if (currentVal != null && currentVal.equals(value)) {
            this.setValue(context, null);
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                if (this.initialiser != null) {
                    msgs = ((InternalEObject)this.initialiser).eInverseRemove((InternalEObject)this, -11, null, msgs);
                }
                return this.basicSetInitialiser((CodeBlock)otherEnd, msgs);
            }
            case 11: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetRule((Rule)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return this.basicSetInitialiser(null, msgs);
            }
            case 11: {
                return this.basicSetRule(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 11: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 12, Rule.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getStaticValue();
            }
            case 10: {
                return this.getInitialiser();
            }
            case 11: {
                return this.getRule();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setStaticValue(newValue);
                return;
            }
            case 10: {
                this.setInitialiser((CodeBlock)newValue);
                return;
            }
            case 11: {
                this.setRule((Rule)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setStaticValue(STATIC_VALUE_EDEFAULT);
                return;
            }
            case 10: {
                this.setInitialiser(null);
                return;
            }
            case 11: {
                this.setRule(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return STATIC_VALUE_EDEFAULT == null ? this.staticValue != null : !STATIC_VALUE_EDEFAULT.equals(this.staticValue);
            }
            case 10: {
                return this.initialiser != null;
            }
            case 11: {
                return this.getRule() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        if (this.isStatic()) {
            result.append(" (staticValue: ");
            result.append(this.staticValue);
            result.append(')');
        }
        return result.toString();
    }

    private void checkStaticFrame(StackFrame frame) {
        CodeBlock initCb = this.getInitialiser();
        StackFrame newFrame = frame;
        while (newFrame != null) {
            if (newFrame.getCodeBlock() == initCb) {
                throw new VMException(newFrame, String.format("Infinite loop detected in field initialiser for %s", this));
            }
            newFrame = newFrame.getParent();
        }
    }
}

