/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.telemetry.tracing.tck.porting.api.ConfigurationAccessor;

@Path(value="JaxRsServerAsyncTestEndpoint")
public class JaxRsServerAsyncTestEndpoint {
    public static final String BAGGAGE_KEY = "test.baggage.key";
    public static final AttributeKey<String> BAGGAGE_VALUE_ATTR = AttributeKey.stringKey((String)"test.baggage");
    private Executor executor = ConfigurationAccessor.get().getExecutor();
    @Inject
    private Tracer tracer;

    @GET
    @Path(value="completionstage")
    public CompletionStage<String> getCompletionStage(@QueryParam(value="baggageValue") String queryValue) {
        Span span = Span.current();
        String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
        if (baggageValue != null) {
            span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
        }
        Executor contextExecutor = Context.taskWrapping((Executor)this.executor);
        CompletableFuture<String> result = CompletableFuture.supplyAsync(this::subtask, contextExecutor);
        return result;
    }

    @GET
    @Path(value="completionstageerror")
    public CompletionStage<Response> getCompletionStageError(@QueryParam(value="baggageValue") String queryValue) {
        Span span = Span.current();
        String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
        if (baggageValue != null) {
            span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
        }
        Executor contextExecutor = Context.taskWrapping((Executor)this.executor);
        CompletableFuture<Response> result = CompletableFuture.supplyAsync(this::subtaskError, contextExecutor);
        return result;
    }

    @GET
    @Path(value="suspend")
    public void getSuspend(@Suspended AsyncResponse async, @QueryParam(value="baggageValue") String queryValue) {
        Span span = Span.current();
        String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
        if (baggageValue != null) {
            span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
        }
        Executor contextExecutor = Context.taskWrapping((Executor)this.executor);
        contextExecutor.execute(() -> {
            try {
                async.resume((Object)this.subtask());
            }
            catch (Throwable t) {
                async.resume(t);
            }
        });
    }

    @GET
    @Path(value="suspenderror")
    public void getSuspendError(@Suspended AsyncResponse async, @QueryParam(value="baggageValue") String queryValue) {
        Span span = Span.current();
        String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
        if (baggageValue != null) {
            span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
        }
        Executor contextExecutor = Context.taskWrapping((Executor)this.executor);
        contextExecutor.execute(() -> {
            try {
                async.resume((Object)this.subtaskError());
            }
            catch (Throwable t) {
                async.resume(t);
            }
        });
    }

    private String subtask() {
        Span span = this.tracer.spanBuilder("subtask").startSpan();
        try {
            String string;
            block12: {
                Scope scope = span.makeCurrent();
                try {
                    Thread.sleep(3000L);
                    String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
                    if (baggageValue != null) {
                        span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
                    }
                    string = "OK";
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                scope.close();
            }
            return string;
        }
        finally {
            span.end();
        }
    }

    private Response subtaskError() {
        Span span = this.tracer.spanBuilder("subtask").startSpan();
        try {
            Response response;
            block12: {
                Scope scope = span.makeCurrent();
                try {
                    Thread.sleep(3000L);
                    String baggageValue = Baggage.current().getEntryValue(BAGGAGE_KEY);
                    if (baggageValue != null) {
                        span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageValue);
                    }
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                scope.close();
            }
            return response;
        }
        finally {
            span.end();
        }
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Collections.singleton(JaxRsServerAsyncTestEndpoint.class);
        }
    }
}

