/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import java.net.URI;
import javax.json.JsonObject;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.ext.CdiCustomClientHeadersFactory;
import org.eclipse.microprofile.rest.client.tck.ext.Counter;
import org.eclipse.microprofile.rest.client.tck.interfaces.CdiClientHeadersFactoryClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithAllClientHeadersFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIClientHeadersFactoryTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(CDIClientHeadersFactoryTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{CdiClientHeadersFactoryClient.class, CdiCustomClientHeadersFactory.class, Counter.class, ReturnWithAllClientHeadersFilter.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    private static CdiClientHeadersFactoryClient client(Class<?> ... providers) {
        try {
            RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri(URI.create("http://localhost:9080/notused"));
            for (Class<?> provider : providers) {
                builder.register(provider);
            }
            return (CdiClientHeadersFactoryClient)builder.build(CdiClientHeadersFactoryClient.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Test
    public void testClientHeadersFactoryInvoked() {
        CdiCustomClientHeadersFactory.isIncomingHeadersMapNull = true;
        CdiCustomClientHeadersFactory.isOutgoingHeadersMapNull = true;
        CdiCustomClientHeadersFactory.passedInOutgoingHeaders.clear();
        JsonObject headers = CDIClientHeadersFactoryTest.client(ReturnWithAllClientHeadersFilter.class).delete("argValue");
        Assert.assertTrue((boolean)CdiCustomClientHeadersFactory.invoked);
        Assert.assertFalse((boolean)CdiCustomClientHeadersFactory.isIncomingHeadersMapNull);
        Assert.assertFalse((boolean)CdiCustomClientHeadersFactory.isOutgoingHeadersMapNull);
        Assert.assertEquals((String)((String)CdiCustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"IntfHeader")), (String)"intfValue");
        Assert.assertEquals((String)((String)CdiCustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"MethodHeader")), (String)"methodValue");
        Assert.assertEquals((String)((String)CdiCustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"ArgHeader")), (String)"argValue");
        Assert.assertEquals((String)headers.getString("IntfHeader"), (String)"intfValueModified");
        Assert.assertEquals((String)headers.getString("MethodHeader"), (String)"methodValueModified");
        Assert.assertEquals((String)headers.getString("ArgHeader"), (String)"argValueModified");
        Assert.assertEquals((String)headers.getString("FactoryHeader"), (String)"factoryValue");
        Assert.assertEquals((String)headers.getString("CDI_INJECT_COUNT"), (String)"1");
        Assert.assertEquals((int)Counter.COUNT.get(), (int)1);
    }
}

