/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.sse;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.microprofile.rest.client.tck.sse.HttpSseServer;
import org.eclipse.microprofile.rest.client.tck.sse.MyEventSource;
import org.testng.Assert;
import org.testng.log4testng.Logger;

public abstract class AbstractSseTest {
    private static final Logger LOG = Logger.getLogger(AbstractSseTest.class);
    protected static final int PORT = Integer.getInteger("sse.server.port", 10000);
    private static ExecutorService serverLaunchExecutor = Executors.newSingleThreadExecutor();

    protected static AtomicReference<Throwable> launchServer(CountDownLatch stopLatch, Consumer<MyEventSource> consumer) throws Exception {
        return AbstractSseTest.launchServer(stopLatch, consumer, null);
    }

    protected static AtomicReference<Throwable> launchServer(CountDownLatch stopLatch, Consumer<MyEventSource> consumer, CountDownLatch cleanupLatch) throws Exception {
        AtomicReference<Throwable> caughtException = new AtomicReference<Throwable>();
        CountDownLatch startLatch = new CountDownLatch(1);
        serverLaunchExecutor.submit(() -> {
            try (HttpSseServer server = new HttpSseServer();){
                server.start(PORT, consumer);
                startLatch.countDown();
                LOG.info((Object)("launchServer server started on port " + PORT));
                Assert.assertTrue((boolean)stopLatch.await(30L, TimeUnit.SECONDS), (String)("Timed out with client expecting " + stopLatch.getCount() + " unreceived event(s)"));
            }
            catch (Throwable t) {
                LOG.error((Object)"launchServer caughtException ", t);
                caughtException.set(t);
            }
            finally {
                if (cleanupLatch != null) {
                    cleanupLatch.countDown();
                }
            }
        });
        Assert.assertTrue((boolean)startLatch.await(30L, TimeUnit.SECONDS), (String)"Mock Sse Server did not start as expected");
        return caughtException;
    }

    protected static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public abstract void testDataOnlySse_InboundSseEvent() throws Exception;

    public abstract void testDataOnlySse_String() throws Exception;

    public abstract void testDataOnlySse_JsonObject() throws Exception;

    public abstract void testCommentOnlySse() throws Exception;

    public abstract void testNamedEventSse() throws Exception;

    public abstract void testServerClosesConnection() throws Exception;
}

