/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.mat.parser.internal.Messages;

public class BitOutputStream
implements Flushable,
Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private OutputStream os;
    private int current;
    private byte[] buffer;
    private int free;
    private int pos;
    private int avail;
    static final int TEMP_BUFFER_SIZE = 128;
    private byte[] tempBuffer = new byte[128];

    public BitOutputStream(OutputStream os) {
        this.os = os;
        this.buffer = new byte[16384];
        this.avail = 16384;
        this.free = 8;
    }

    @Override
    public void flush() throws IOException {
        this.align();
        this.os.write(this.buffer, 0, this.pos);
        this.pos = 0;
        this.avail = this.buffer.length;
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
        this.os = null;
        this.buffer = null;
        this.tempBuffer = null;
    }

    private void write(int b) throws IOException {
        if (this.avail-- == 0) {
            if (this.os == null) {
                this.avail = 0;
                throw new IOException(Messages.BitOutputStream_Error_ArrayFull);
            }
            if (this.buffer == null) {
                this.os.write(b);
                this.avail = 0;
                return;
            }
            this.os.write(this.buffer);
            this.avail = this.buffer.length - 1;
            this.pos = 0;
        }
        this.buffer[this.pos++] = (byte)b;
    }

    private int writeInCurrent(int b, int len) throws IOException {
        this.current |= (b & (1 << len) - 1) << (this.free -= len);
        if (this.free == 0) {
            this.write(this.current);
            this.free = 8;
            this.current = 0;
        }
        return len;
    }

    private int align() throws IOException {
        if (this.free != 8) {
            return this.writeInCurrent(0, this.free);
        }
        return 0;
    }

    public int writeBit(int bit) throws IOException {
        return this.writeInCurrent(bit, 1);
    }

    public int writeInt(int x, int len) throws IOException {
        int blocks;
        if (len <= this.free) {
            return this.writeInCurrent(x, len);
        }
        int queue = len - this.free & 7;
        int i = blocks = len - this.free >> 3;
        if (queue != 0) {
            this.tempBuffer[blocks] = (byte)x;
            x >>= queue;
        }
        while (i-- != 0) {
            this.tempBuffer[i] = (byte)x;
            x >>>= 8;
        }
        this.writeInCurrent(x, this.free);
        i = 0;
        while (i < blocks) {
            this.write(this.tempBuffer[i]);
            ++i;
        }
        if (queue != 0) {
            this.writeInCurrent(this.tempBuffer[blocks], queue);
        }
        return len;
    }
}

