/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SimpleStringTokenizer
implements Iterable<String> {
    private String subject;
    private char delim;

    public SimpleStringTokenizer(String subject, char delim) {
        this.subject = subject;
        this.delim = delim;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int position = 0;
            int maxPosition;
            {
                this.maxPosition = SimpleStringTokenizer.this.subject.length();
            }

            @Override
            public boolean hasNext() {
                return this.position < this.maxPosition;
            }

            @Override
            public String next() {
                if (this.position >= this.maxPosition) {
                    throw new NoSuchElementException();
                }
                int p = SimpleStringTokenizer.this.subject.indexOf(SimpleStringTokenizer.this.delim, this.position);
                if (p < 0) {
                    String answer = SimpleStringTokenizer.this.subject.substring(this.position);
                    this.position = this.maxPosition;
                    return answer;
                }
                String answer = SimpleStringTokenizer.this.subject.substring(this.position, p);
                this.position = p + 1;
                return answer;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String[] split(String subject, char delim) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String s : new SimpleStringTokenizer(subject, delim)) {
            answer.add(s.trim());
        }
        return answer.toArray(new String[0]);
    }
}

