/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import org.eclipse.birt.chart.internal.computations.MatrixDecomposition;

public class Matrix {
    private double[][] data;
    private int m;
    private int n;

    public Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.data = new double[m][n];
    }

    public Matrix(double[][] data, int m, int n) {
        this.data = data;
        this.m = m;
        this.n = n;
    }

    public Matrix(double[] A, int m) {
        this.m = m;
        int n = this.n = m != 0 ? A.length / m : 0;
        if (m * this.n != A.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.data = new double[m][this.n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < this.n) {
                this.data[i][j] = A[i + j * m];
                ++j;
            }
            ++i;
        }
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] A = matrix.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                A[i][j] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public double[][] getArray() {
        return this.data;
    }

    public double[][] getArrayCopy() {
        double[][] A = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                A[i][j] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return A;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.data[i][j];
    }

    public void set(int i, int j, double s) {
        this.data[i][j] = s;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] C = matrix.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[j][i] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix mResult = new Matrix(this.m, matrix.n);
        double[][] A = mResult.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < matrix.n) {
                double s = 0.0;
                int k = 0;
                while (k < this.n) {
                    s += this.data[i][k] * matrix.data[k][j];
                    ++k;
                }
                A[i][j] = s;
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public static Matrix identity(int m, int n) {
        Matrix matrix = new Matrix(m, n);
        double[][] A = matrix.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                A[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Matrix inverse() {
        return new MatrixDecomposition(this).decomposition();
    }
}

