/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collectionextract;

import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public class ExtractedCollection
extends AbstractExtractedCollection<IObject, ICollectionExtractor> {
    private static final long serialVersionUID = 1L;

    public ExtractedCollection(IObject coll, ICollectionExtractor extractor) {
        super(coll, extractor);
    }

    @Override
    public Iterator<IObject> iterator() {
        try {
            final int[] array = this.getExtractor().extractEntryIds(this.getCollection());
            return new Iterator<IObject>(){
                final ISnapshot snapshot;
                int index;
                {
                    this.snapshot = ExtractedCollection.this.getCollection().getSnapshot();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public IObject next() {
                    try {
                        return this.snapshot.getObject(array[this.index++]);
                    }
                    catch (SnapshotException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getNumberOfNotNullElements() throws SnapshotException {
        return this.getExtractor().getNumberOfNotNullElements(this.getCollection());
    }
}

