/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.eclipse.lyo.core.util.StringUtils;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.XMLLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OSLC4JUtils {
    private static final Logger log = LoggerFactory.getLogger(OSLC4JUtils.class);
    private static String publicURI = System.getProperty("org.eclipse.lyo.oslc4j.publicURI");
    private static String servletPath = null;
    private static String servletURI = null;
    private static String useBeanClassForParsing = System.getProperty("org.eclipse.lyo.oslc4j.useBeanClassForParsing");
    private static String inferTypeFromShape = System.getProperty("org.eclipse.lyo.oslc4j.inferTypeFromResourceShape");
    private static List<ResourceShape> shapes = new ArrayList<ResourceShape>();

    public static boolean useStrictDatatypes() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.strictDatatypes", true);
    }

    public static boolean alwaysAbbrevXML() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.alwaysXMLAbbrev", false);
    }

    public static boolean relativeURIsAreDisabled() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.disableRelativeURIs", true);
    }

    public static Object getValueBasedOnResourceShapeType(HashSet<String> rdfTypesList, QName propertyQName, Object originalValue) throws DatatypeConfigurationException, IllegalArgumentException, InstantiationException {
        if (null == rdfTypesList || rdfTypesList.isEmpty() || null == propertyQName || null == originalValue) {
            return null;
        }
        try {
            List<ResourceShape> shapes = OSLC4JUtils.getShapes();
            if (null == shapes || shapes.isEmpty()) {
                return null;
            }
            String propertyName = propertyQName.getNamespaceURI() + propertyQName.getLocalPart();
            TypeMapper typeMapper = TypeMapper.getInstance();
            for (ResourceShape shape : shapes) {
                Property[] props;
                if (!OSLC4JUtils.doesResourceShapeMatchRdfTypes(shape, rdfTypesList)) continue;
                for (Property prop : props = shape.getProperties()) {
                    RDFDatatype dataTypeFromShape;
                    URI propValueType;
                    URI propDefinition = prop.getPropertyDefinition();
                    if (!propertyName.equals(propDefinition.toString()) || null == (propValueType = prop.getValueType()) || null == (dataTypeFromShape = typeMapper.getTypeByName(propValueType.toString()))) continue;
                    try {
                        if (OSLC4JUtils.isXmlLiteralProperty(propValueType)) {
                            return OSLC4JUtils.xmlLiteralPropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isDateProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.datePropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isBooleanProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.booleanPropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isDoubleProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.doublePropertyFrom(originalValue);
                        }
                        if (OSLC4JUtils.isFloatProperty(dataTypeFromShape)) {
                            return OSLC4JUtils.floatPropertyFrom(originalValue);
                        }
                        Constructor cons = dataTypeFromShape.getJavaClass().getConstructor(String.class);
                        return cons.newInstance(originalValue.toString());
                    }
                    catch (IllegalArgumentException | InvocationTargetException | DatatypeFormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.warn("Could not create extended value <{}> based on shape", (Object)propertyQName, (Object)e);
            return null;
        }
        return null;
    }

    public static String getPublicURI() {
        return publicURI;
    }

    public static void setPublicURI(String newPublicURI) throws MalformedURLException {
        if (newPublicURI != null && !newPublicURI.isEmpty()) {
            new URL(newPublicURI);
        }
        publicURI = newPublicURI;
    }

    public static String getServletPath() {
        return servletPath;
    }

    @Deprecated
    public static String resolveURI(HttpServletRequest request, boolean includePath) {
        UriBuilder builder;
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        String configuredPublicURI = OSLC4JUtils.getPublicURI();
        if (configuredPublicURI != null && !configuredPublicURI.isEmpty()) {
            Object uriToBuild = configuredPublicURI;
            if (includePath) {
                uriToBuild = configuredPublicURI + "/" + servletPath + pathInfo;
            }
            builder = UriBuilder.fromUri((String)uriToBuild);
        } else {
            String hostname = OSLC4JUtils.guessHostname(request);
            String contextPath = request.getContextPath();
            Object pathToBuild = contextPath;
            if (includePath) {
                pathToBuild = contextPath + servletPath + pathInfo;
            }
            builder = UriBuilder.fromPath((String)pathToBuild).scheme(request.getScheme()).host(hostname).port(request.getServerPort());
        }
        URI resolvedURI = builder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static String getServletURI() {
        return servletURI;
    }

    public static boolean useBeanClassForParsing() {
        boolean result = false;
        if (null != useBeanClassForParsing) {
            result = Boolean.parseBoolean(useBeanClassForParsing);
        }
        return result;
    }

    public static String getUseBeanClassForParsing() {
        return useBeanClassForParsing;
    }

    public static List<ResourceShape> getShapes() {
        return shapes;
    }

    public static boolean inferTypeFromShape() {
        boolean result = false;
        if (null != inferTypeFromShape) {
            result = Boolean.parseBoolean(inferTypeFromShape);
        }
        return result;
    }

    public static String getInferTypeFromShape() {
        return inferTypeFromShape;
    }

    public static void setShapes(List<ResourceShape> shapes) {
        OSLC4JUtils.shapes = shapes;
    }

    public static boolean isHostResolutionDisabled() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.disableHostResolution", false);
    }

    public static boolean isQueryResultListAsContainer() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.queryResultListAsContainer", false);
    }

    public static void setUseBeanClassForParsing(String useBeanClassForParsing) {
        OSLC4JUtils.useBeanClassForParsing = useBeanClassForParsing;
    }

    public static void setHostResolutionDisabled(boolean hostResDisabled) {
        System.setProperty("org.eclipse.lyo.oslc4j.disableHostResolution", Boolean.toString(hostResDisabled));
    }

    public static String resolveFullUri(HttpServletRequest request) {
        UriBuilder servletUriBuilder = OSLC4JUtils.servletUriBuilderFrom(request);
        String pathInfo = request.getPathInfo();
        UriBuilder publicUriBuilder = servletUriBuilder.path(pathInfo);
        URI resolvedURI = publicUriBuilder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static String resolveServletUri(HttpServletRequest request) {
        UriBuilder servletUriBuilder = OSLC4JUtils.servletUriBuilderFrom(request);
        URI resolvedURI = servletUriBuilder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static void setServletPath(String newServletPath) {
        if (newServletPath != null && !newServletPath.isEmpty()) {
            URI testServletURI = OSLC4JUtils.servletUriBuilderFrom(OSLC4JUtils.getPublicURI(), newServletPath).build(new Object[0]);
            servletPath = newServletPath;
            servletURI = testServletURI.toString();
        } else {
            servletPath = null;
            servletURI = null;
        }
    }

    private static UriBuilder servletUriBuilderFrom(HttpServletRequest request) {
        String publicUri = OSLC4JUtils.getOrConstructPublicUriBase(request);
        String servletPath = OSLC4JUtils.getServletPath() != null ? OSLC4JUtils.getServletPath() : request.getServletPath();
        return OSLC4JUtils.servletUriBuilderFrom(publicUri, servletPath);
    }

    private static UriBuilder servletUriBuilderFrom(String publicUri, String servletPath) {
        return UriBuilder.fromUri((String)publicUri).path(servletPath);
    }

    private static String getOrConstructPublicUriBase(HttpServletRequest request) {
        String publicUri = OSLC4JUtils.getPublicURI();
        if (publicUri == null || publicUri.isEmpty()) {
            String scheme = request.getScheme();
            String hostName = OSLC4JUtils.guessHostname(request);
            int serverPort = request.getServerPort();
            String contextPath = request.getContextPath();
            publicUri = OSLC4JUtils.constructPublicUriBase(scheme, hostName, serverPort, contextPath);
        }
        return publicUri;
    }

    private static String constructPublicUriBase(String scheme, String hostName, int serverPort, String contextPath) {
        return UriBuilder.fromPath((String)contextPath).scheme(scheme).host(hostName).port(serverPort).build(new Object[0]).normalize().toString();
    }

    @Deprecated
    private static String guessHostname(HttpServletRequest request) {
        String hostName = "localhost";
        boolean getHostNameFromRequest = false;
        if (OSLC4JUtils.isHostResolutionDisabled()) {
            getHostNameFromRequest = true;
        } else {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                log.info("Unable to resolve hostname. Extracting hostname from request.");
                getHostNameFromRequest = true;
            }
        }
        if (getHostNameFromRequest) {
            hostName = request.getServerName();
        }
        return hostName;
    }

    public static void setInferTypeFromShape(String inferTypeFromShape) {
        OSLC4JUtils.inferTypeFromShape = inferTypeFromShape;
    }

    private static Boolean parseBooleanPropertyOrDefault(String key, boolean defaultValue) {
        Boolean value;
        String property = System.getProperty(key);
        if (StringUtils.isNullOrEmpty(property)) {
            value = defaultValue;
        } else {
            try {
                value = OSLC4JUtils.parseBooleanStrict(property.trim());
            }
            catch (IllegalArgumentException e) {
                log.error("System property '{}' holds illegal value: '{}' (only 'true' or 'false' are allowed)", (Object)key, (Object)property);
                throw e;
            }
        }
        return value;
    }

    private static boolean doesResourceShapeMatchRdfTypes(ResourceShape shape, HashSet<String> rdfTypesList) {
        if (null != shape) {
            URI[] describes;
            for (URI describeUri : describes = shape.getDescribes()) {
                String describeUriStr = describeUri.toASCIIString();
                if (!rdfTypesList.contains(describeUriStr)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean parseBooleanStrict(String input) throws IllegalArgumentException {
        if ("true".equalsIgnoreCase(input)) {
            return true;
        }
        if ("false".equalsIgnoreCase(input)) {
            return false;
        }
        throw new IllegalArgumentException("Value has to be either true or false");
    }

    private static Object floatPropertyFrom(Object originalValue) {
        return XSDDatatype.XSDfloat.parseValidated(originalValue.toString());
    }

    private static Object doublePropertyFrom(Object originalValue) {
        return XSDDatatype.XSDdouble.parseValidated(originalValue.toString());
    }

    private static Object booleanPropertyFrom(Object originalValue) {
        if (Boolean.TRUE.toString().equals(originalValue.toString()) || "1".equals(originalValue.toString())) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(originalValue.toString()) || "0".equals(originalValue.toString())) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("'" + originalValue.toString() + "' has wrong format for Boolean.");
    }

    private static Object datePropertyFrom(Object originalValue) throws DatatypeConfigurationException {
        String dateStr = originalValue.toString();
        GregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateStr).toGregorianCalendar();
        XSDDateTime xsdDateTime = new XSDDateTime((Calendar)calendar);
        return xsdDateTime.asCalendar().getTime();
    }

    private static XMLLiteral xmlLiteralPropertyFrom(Object originalValue) {
        return new XMLLiteral(originalValue.toString());
    }

    private static boolean isFloatProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Float.class.getCanonicalName());
    }

    private static boolean isDoubleProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Double.class.getCanonicalName());
    }

    private static boolean isBooleanProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(Boolean.class.getCanonicalName());
    }

    private static boolean isDateProperty(RDFDatatype dataTypeFromShape) {
        return dataTypeFromShape.getJavaClass().getCanonicalName().equals(XSDDateTime.class.getCanonicalName());
    }

    private static boolean isXmlLiteralProperty(URI propValueType) {
        return XMLLiteralType.theXMLLiteralType.getURI().equals(propValueType.toString());
    }

    public static RDFDatatype getDataTypeBasedOnResourceShapeType(HashSet<String> rdfTypesList, org.apache.jena.rdf.model.Property property) {
        if (null != rdfTypesList && !rdfTypesList.isEmpty() && null != property) {
            try {
                List<ResourceShape> shapes = OSLC4JUtils.getShapes();
                if (null != shapes && !shapes.isEmpty()) {
                    String propertyName = property.getURI();
                    TypeMapper typeMapper = TypeMapper.getInstance();
                    for (ResourceShape shape : shapes) {
                        Property[] props;
                        if (!OSLC4JUtils.doesResourceShapeMatchRdfTypes(shape, rdfTypesList)) continue;
                        for (Property prop : props = shape.getProperties()) {
                            URI propValueType;
                            URI propDefinition = prop.getPropertyDefinition();
                            if (!propertyName.equals(propDefinition.toString()) || null == (propValueType = prop.getValueType())) continue;
                            return typeMapper.getTypeByName(propValueType.toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("Could not find Data Type <{}> based on shape", (Object)property, (Object)e);
                return null;
            }
        }
        return null;
    }

    public static boolean isLyoStorePagingUnsafe() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.storePagingUnsafe", false);
    }

    public static void setLyoStorePagingUnsafe(boolean value) {
        System.setProperty("org.eclipse.lyo.oslc4j.storePagingUnsafe", Boolean.toString(value));
    }

    public static boolean hasLyoStorePagingPreciseLimit() {
        return OSLC4JUtils.parseBooleanPropertyOrDefault("org.eclipse.lyo.oslc4j.storePagingPreciseLimit", true);
    }

    public static void setLyoStorePagingPreciseLimit(boolean value) {
        System.setProperty("org.eclipse.lyo.oslc4j.storePagingPreciseLimit", Boolean.toString(value));
    }

    public static boolean isWellFormed(String xmlLiteral) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder db = factory.newDocumentBuilder();
            ByteArrayInputStream targetStream = new ByteArrayInputStream(xmlLiteral.getBytes());
            db.parse(targetStream);
            return true;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("XML Validator cannot be initialized");
        }
        catch (IOException | SAXException e) {
            return false;
        }
    }

    public static boolean isWellFormed(XMLLiteral literal) {
        return OSLC4JUtils.isWellFormed(literal.getValue());
    }
}

