/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Assert;
import org.junit.Test;

public class JaxRsCodeLensTest
extends BasePropertiesManagerTest {
    @Test
    public void urlCodeLensProperties() throws Exception {
        IJavaProject javaProject = JaxRsCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.hibernate_orm_resteasy);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/hibernate/orm/FruitResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsCodeLensTest.assertCodeLenses(8080, params, utils);
    }

    @Test
    public void urlCodeLensYaml() throws Exception {
        IJavaProject javaProject = JaxRsCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.hibernate_orm_resteasy_yaml);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/hibernate/orm/FruitResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsCodeLensTest.assertCodeLenses(8080, params, utils);
    }

    private static void assertCodeLenses(int port, MicroProfileJavaCodeLensParams params, IJDTUtils utils) throws JavaModelException {
        List lenses = PropertiesManagerForJava.getInstance().codeLens(params, utils, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)2L, (long)lenses.size());
        CodeLens lensForGet = (CodeLens)lenses.get(0);
        Assert.assertNotNull((Object)lensForGet.getCommand());
        Assert.assertEquals((Object)("http://localhost:" + port + "/fruits"), (Object)lensForGet.getCommand().getTitle());
        CodeLens lensForGetSingle = (CodeLens)lenses.get(1);
        Assert.assertNotNull((Object)lensForGetSingle.getCommand());
        Assert.assertEquals((Object)("http://localhost:" + port + "/fruits/{id}"), (Object)lensForGetSingle.getCommand().getTitle());
    }
}

