/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.cdi;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class ManagedBeanConstructorTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void managedBeanAnnotations() throws Exception {
        IJavaProject javaProject = ManagedBeanConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/cdi/ManagedBeanConstructor.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(21, 8, 30, "The @Inject annotation must define a managed bean constructor that takes parameters, or the managed bean must resolve to having a no-arg constructor instead.", DiagnosticSeverity.Error, "jakarta-cdi", "InvalidManagedBeanWithInvalidConstructor");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d);
        TextEdit te1 = JakartaForJavaAssert.te(15, 44, 21, 1, "\nimport jakarta.inject.Inject;\n\n@Dependent\npublic class ManagedBeanConstructor {\n\tprivate int a;\n\t\n\t@Inject\n\t");
        TextEdit te2 = JakartaForJavaAssert.te(19, 1, 19, 1, "protected ManagedBeanConstructor() {\n\t}\n\n\t");
        TextEdit te3 = JakartaForJavaAssert.te(19, 1, 19, 1, "public ManagedBeanConstructor() {\n\t}\n\n\t");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Add a default 'protected' constructor to this class", d, te2);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Add a default 'public' constructor to this class", d, te3);
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Insert @Inject", d, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca1, ca2, ca3);
    }
}

