/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ASTRewriteCorrectionProposal;

public class RemoveAnnotationProposal
extends ASTRewriteCorrectionProposal {
    private final CompilationUnit fInvocationNode;
    private final IBinding fBinding;
    private final String[] annotations;
    private final ASTNode declaringNode;

    public RemoveAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, ASTNode declaringNode, String ... annotations) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.fInvocationNode = invocationNode;
        this.fBinding = binding;
        this.declaringNode = declaringNode;
        this.annotations = annotations;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode declNode = this.declaringNode;
        ASTNode boundNode = this.fInvocationNode.findDeclaringNode(this.fBinding);
        CompilationUnit newRoot = this.fInvocationNode;
        if (boundNode == null) {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        if (declNode instanceof VariableDeclarationFragment) {
            declNode = declNode.getParent();
        }
        boolean isField = declNode instanceof FieldDeclaration;
        boolean isMethod = declNode instanceof MethodDeclaration;
        boolean isType = declNode instanceof TypeDeclaration;
        String[] annotations = this.getAnnotations();
        if (isField || isMethod || isType) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            new ContextSensitiveImportRewriteContext(declNode, imports);
            List children = isMethod ? (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS2_PROPERTY) : (isType ? (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS2_PROPERTY) : (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY));
            for (ASTNode child : children) {
                ITypeBinding binding;
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                String matchingFqn = Arrays.stream(annotations).filter(fqn -> RemoveAnnotationProposal.matchesAnnotation(fqn, annotation.getTypeName().toString())).findFirst().orElse(null);
                if (matchingFqn == null || !(binding = annotation.resolveTypeBinding()).getQualifiedName().equals(matchingFqn)) continue;
                rewrite.remove(child, null);
            }
            return rewrite;
        }
        return null;
    }

    protected CompilationUnit getInvocationNode() {
        return this.fInvocationNode;
    }

    protected IBinding getBinding() {
        return this.fBinding;
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }

    private static boolean matchesAnnotation(String fqn, String typeName) {
        return fqn.equals(typeName) || fqn.endsWith("." + typeName);
    }
}

