/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.beanvalidation;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.Test;

public class BeanValidationTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void validFieldConstraints() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/ValidConstraints.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, new Diagnostic[0]);
    }

    @Test
    public void fieldConstraintValidation() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/FieldConstraintValidation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(10, 16, 23, "The @AssertTrue annotation can only be used on boolean and Boolean type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"AssertTrue");
        Diagnostic d2 = JakartaForJavaAssert.d(13, 19, 24, "The @AssertFalse annotation can only be used on boolean and Boolean type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"AssertFalse");
        Diagnostic d3 = JakartaForJavaAssert.d(17, 19, 29, "The @DecimalMax annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"DecimalMax");
        Diagnostic d4 = JakartaForJavaAssert.d(17, 19, 29, "The @DecimalMin annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"DecimalMin");
        Diagnostic d5 = JakartaForJavaAssert.d(20, 20, 26, "The @Digits annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"Digits");
        Diagnostic d6 = JakartaForJavaAssert.d(23, 20, 32, "The @Email annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"Email");
        Diagnostic d7 = JakartaForJavaAssert.d(26, 20, 34, "The @FutureOrPresent annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"FutureOrPresent");
        Diagnostic d8 = JakartaForJavaAssert.d(29, 19, 30, "The @Future annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"Future");
        Diagnostic d9 = JakartaForJavaAssert.d(33, 20, 23, "The @Min annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonMinMaxMethodOrField", (Object)"Min");
        Diagnostic d10 = JakartaForJavaAssert.d(33, 20, 23, "The @Max annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonMinMaxMethodOrField", (Object)"Max");
        Diagnostic d11 = JakartaForJavaAssert.d(36, 20, 27, "The @Negative annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"Negative");
        Diagnostic d12 = JakartaForJavaAssert.d(39, 19, 25, "The @NegativeOrZero annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"NegativeOrZero");
        Diagnostic d13 = JakartaForJavaAssert.d(42, 20, 32, "The @NotBlank annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"NotBlank");
        Diagnostic d14 = JakartaForJavaAssert.d(45, 21, 31, "The @Pattern annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"Pattern");
        Diagnostic d15 = JakartaForJavaAssert.d(48, 19, 33, "The @Past annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"Past");
        Diagnostic d16 = JakartaForJavaAssert.d(51, 19, 33, "The @PastOrPresent annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"PastOrPresent");
        Diagnostic d17 = JakartaForJavaAssert.d(54, 21, 25, "The @Positive annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"Positive");
        Diagnostic d19 = JakartaForJavaAssert.d(60, 27, 36, "Constraint annotations are not allowed on static fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"AssertTrue");
        Diagnostic d20 = JakartaForJavaAssert.d(63, 27, 36, "Constraint annotations are not allowed on static fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"Past");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d19, d20);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(9, 4, 10, 4, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d1, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d19);
        TextEdit te1 = JakartaForJavaAssert.te(59, 4, 60, 4, "");
        TextEdit te2 = JakartaForJavaAssert.te(60, 11, 60, 18, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d19, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d19, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams3 = JakartaForJavaAssert.createCodeActionParams(uri, d20);
        TextEdit te3 = JakartaForJavaAssert.te(62, 4, 63, 4, "");
        TextEdit te4 = JakartaForJavaAssert.te(63, 11, 63, 18, "");
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Past from element", d20, te3);
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d20, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams3, IJDT_UTILS, ca3, ca4);
    }

    @Test
    public void methodConstraintValidation() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/MethodConstraintValidation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(20, 26, 38, "Constraint annotations are not allowed on static methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"AssertTrue");
        Diagnostic d2 = JakartaForJavaAssert.d(25, 18, 28, "The @AssertTrue annotation can only be used on boolean and Boolean type methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"AssertTrue");
        Diagnostic d3 = JakartaForJavaAssert.d(30, 23, 33, "Constraint annotations are not allowed on static methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"AssertFalse");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(19, 4, 20, 4, "");
        TextEdit te2 = JakartaForJavaAssert.te(20, 10, 20, 17, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d1, te);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d1, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca2);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        te = JakartaForJavaAssert.te(24, 4, 25, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d2, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        te = JakartaForJavaAssert.te(19, 4, 20, 4, "");
        te2 = JakartaForJavaAssert.te(20, 10, 20, 17, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertFalse from element", d3, te);
        ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d3, te2);
    }
}

