/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4jakarta.commons.DocumentFormat;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCompletionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsSettings;
import org.eclipse.lsp4jakarta.commons.JakartaJavaFileInfo;
import org.eclipse.lsp4jakarta.commons.JakartaJavaFileInfoParams;
import org.eclipse.lsp4jakarta.commons.JavaCursorContextKind;
import org.eclipse.lsp4jakarta.commons.JavaCursorContextResult;
import org.eclipse.lsp4jakarta.jdt.core.ASTNodeUtils;
import org.eclipse.lsp4jakarta.jdt.core.java.completion.JavaCompletionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.JavaFeaturesRegistry;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.codeaction.CodeActionHandler;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.completion.JavaCompletionDefinition;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.diagnostics.JavaDiagnosticsDefinition;

public class PropertiesManagerForJava {
    private static final PropertiesManagerForJava INSTANCE = new PropertiesManagerForJava();
    private final CodeActionHandler codeActionHandler = new CodeActionHandler();

    public static PropertiesManagerForJava getInstance() {
        return INSTANCE;
    }

    private PropertiesManagerForJava() {
    }

    public CompletionList completion(JakartaJavaCompletionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return null;
        }
        Position completionPosition = params.getPosition();
        int completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
        ArrayList completionItems = new ArrayList();
        JavaCompletionContext completionContext = new JavaCompletionContext(uri, typeRoot, utils, completionOffset);
        List<JavaCompletionDefinition> completions = JavaFeaturesRegistry.getInstance().getJavaCompletionDefinitions().stream().filter(completion -> completion.isAdaptedForCompletion(completionContext, monitor)).collect(Collectors.toList());
        if (completions.isEmpty()) {
            return null;
        }
        completions.forEach(completion -> {
            List<? extends CompletionItem> collectedCompletionItems = completion.collectCompletionItems(completionContext, monitor);
            if (collectedCompletionItems != null) {
                completionItems.addAll(collectedCompletionItems);
            }
        });
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionList completionList = new CompletionList();
        completionList.setItems(completionItems);
        return completionList;
    }

    public JavaCursorContextResult javaCursorContext(JakartaJavaCompletionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return new JavaCursorContextResult(JavaCursorContextKind.IN_EMPTY_FILE, "");
        }
        CompilationUnit ast = ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)typeRoot), (IProgressMonitor)monitor);
        JavaCursorContextKind kind = PropertiesManagerForJava.getJavaCursorContextKind(params, typeRoot, ast, utils, monitor);
        String prefix = PropertiesManagerForJava.getJavaCursorPrefix(params, typeRoot, ast, utils, monitor);
        return new JavaCursorContextResult(kind, prefix);
    }

    private static JavaCursorContextKind getJavaCursorContextKind(JakartaJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        ASTNode node;
        if (typeRoot.findPrimaryType() == null) {
            return JavaCursorContextKind.IN_EMPTY_FILE;
        }
        Position completionPosition = params.getPosition();
        int completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
        NodeFinder nodeFinder = new NodeFinder((ASTNode)ast, completionOffset, 0);
        ASTNode oldNode = node = nodeFinder.getCoveringNode();
        while (!(node == null || node instanceof AbstractTypeDeclaration && PropertiesManagerForJava.offsetOfFirstNonAnnotationModifier((BodyDeclaration)node) < completionOffset)) {
            if (node.getParent() != null) {
                switch (node.getParent().getNodeType()) {
                    case 23: 
                    case 31: 
                    case 72: 
                    case 82: {
                        if (ASTNodeUtils.isAnnotation(node) || node.getStartPosition() >= completionOffset) break;
                        return JavaCursorContextKind.NONE;
                    }
                }
            }
            oldNode = node;
            node = node.getParent();
        }
        if (node == null) {
            FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset, false);
            oldNode.accept((ASTVisitor)visitor);
            switch (visitor.getAnnotatedNodeType()) {
                case 55: 
                case 71: 
                case 81: 
                case 103: {
                    if (visitor.isInAnnotations()) {
                        return JavaCursorContextKind.IN_CLASS_ANNOTATIONS;
                    }
                    return JavaCursorContextKind.BEFORE_CLASS;
                }
            }
            return JavaCursorContextKind.NONE;
        }
        AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
        FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset);
        typeDeclaration.accept((ASTVisitor)visitor);
        switch (visitor.getAnnotatedNodeType()) {
            case 55: 
            case 71: 
            case 81: 
            case 103: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_CLASS_ANNOTATIONS : JavaCursorContextKind.BEFORE_CLASS;
            }
            case 31: 
            case 82: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_METHOD_ANNOTATIONS : JavaCursorContextKind.BEFORE_METHOD;
            }
            case 23: 
            case 72: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_FIELD_ANNOTATIONS : JavaCursorContextKind.BEFORE_FIELD;
            }
        }
        return JavaCursorContextKind.IN_CLASS;
    }

    @NonNull
    private static String getJavaCursorPrefix(JakartaJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        String fileContents;
        int completionOffset;
        block5: {
            Position completionPosition = params.getPosition();
            completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
            fileContents = null;
            try {
                buffer = typeRoot.getBuffer();
                if (buffer != null) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return "";
            }
        }
        fileContents = buffer.getContents();
        if (fileContents == null) {
            return "";
        }
        int i = completionOffset;
        while (i > 0 && !Character.isWhitespace(fileContents.charAt(i - 1))) {
            --i;
        }
        return fileContents.substring(i, completionOffset);
    }

    private static ITypeRoot resolveTypeRoot(String uri, IJDTUtils utils, IProgressMonitor monitor) {
        utils.waitForLifecycleJobs(monitor);
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = utils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return null;
        }
        return unit != null ? unit : classFile;
    }

    public List<? extends CodeAction> codeAction(JakartaJavaCodeActionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.codeAction(params, utils, monitor);
    }

    public CodeAction resolveCodeAction(CodeAction unresolved, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.resolveCodeAction(unresolved, utils, monitor);
    }

    public List<PublishDiagnosticsParams> diagnostics(JakartaJavaDiagnosticsParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        List<String> uris = params.getUris();
        if (uris == null) {
            return Collections.emptyList();
        }
        DocumentFormat documentFormat = params.getDocumentFormat();
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            this.collectDiagnostics(uri, utils, documentFormat, params.getSettings(), diagnostics, monitor);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    private void collectDiagnostics(String uri, IJDTUtils utils, DocumentFormat documentFormat, JakartaJavaDiagnosticsSettings settings, List<Diagnostic> diagnostics, IProgressMonitor monitor) {
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return;
        }
        JavaDiagnosticsContext context = new JavaDiagnosticsContext(uri, typeRoot, utils, documentFormat, settings);
        List<JavaDiagnosticsDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaDiagnosticsDefinitions().stream().filter(definition -> definition.isAdaptedForDiagnostics(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginDiagnostics(context, monitor));
        definitions.forEach(definition -> {
            List<Diagnostic> collectedDiagnostics = definition.collectDiagnostics(context, monitor);
            if (collectedDiagnostics != null && !collectedDiagnostics.isEmpty()) {
                diagnostics.addAll(collectedDiagnostics);
            }
        });
        definitions.forEach(definition -> definition.endDiagnostics(context, monitor));
    }

    private static int offsetOfFirstNonAnnotationModifier(BodyDeclaration node) {
        List modifiers = node.modifiers();
        int i = 0;
        while (i < modifiers.size()) {
            ASTNode modifier = (ASTNode)modifiers.get(i);
            if (!ASTNodeUtils.isAnnotation(modifier)) {
                return modifier.getStartPosition();
            }
            ++i;
        }
        BodyDeclaration bodyDeclaration = node;
        if (bodyDeclaration instanceof MethodDeclaration && (i = (MethodDeclaration)bodyDeclaration) == (MethodDeclaration)bodyDeclaration) {
            if (method.getReturnType2() != null) {
                return method.getReturnType2().getStartPosition();
            }
            return method.getName().getStartPosition();
        }
        if (node instanceof FieldDeclaration var5_7) {
            return field.getType().getStartPosition();
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
        int nameOffset = type.getName().getStartPosition();
        switch (type.getNodeType()) {
            case 55: {
                if (((TypeDeclaration)type).isInterface()) {
                    v0 = "interface";
                    break;
                }
                v0 = "class";
                break;
            }
            case 71: {
                v0 = "enum";
                break;
            }
            case 81: {
                v0 = "@interface";
                break;
            }
            case 103: {
                v0 = "record";
                break;
            }
            default: {
                v0 = "";
            }
        }
        int keywordLength = v0.length();
        return nameOffset - (keywordLength + 1);
    }

    private static boolean isGenerated(ASTNode node) {
        try {
            return (Boolean)node.getClass().getField("$isGenerated").get(node);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    public JakartaJavaFileInfo fileInfo(JakartaJavaFileInfoParams params, IJDTUtils utils) {
        String uri = params.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        if (unit != null && unit.exists()) {
            JakartaJavaFileInfo fileInfo = new JakartaJavaFileInfo();
            String packageName = unit.getParent() != null ? unit.getParent().getElementName() : "";
            fileInfo.setPackageName(packageName);
            return fileInfo;
        }
        return null;
    }

    private static class FindWhatsBeingAnnotatedASTVisitor
    extends ASTVisitor {
        private int completionOffset;
        private int closest = Integer.MAX_VALUE;
        private int annotatedNode = 0;
        private boolean visitedParentType;
        private boolean inAnnotations = false;

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset, boolean startingInParent) {
            this.completionOffset = completionOffset;
            this.visitedParentType = !startingInParent;
        }

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset) {
            this(completionOffset, true);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(RecordDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        private boolean visitAbstractType(AbstractTypeDeclaration node) {
            if (!this.visitedParentType) {
                this.visitedParentType = true;
                return true;
            }
            return this.visitNode((BodyDeclaration)node);
        }

        private boolean visitNode(BodyDeclaration node) {
            int start;
            if (PropertiesManagerForJava.isGenerated((ASTNode)node)) {
                return false;
            }
            int n = start = node.modifiers().isEmpty() ? node.getStartPosition() : PropertiesManagerForJava.offsetOfFirstNonAnnotationModifier(node);
            if (start < this.closest && this.completionOffset <= start) {
                this.closest = node.getStartPosition();
                this.annotatedNode = node.getNodeType();
                this.inAnnotations = node.getStartPosition() < this.completionOffset && this.completionOffset <= start;
            }
            return false;
        }

        public int getAnnotatedNodeType() {
            return this.annotatedNode;
        }

        public boolean isInAnnotations() {
            return this.inAnnotations;
        }
    }
}

