/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

/**
 * The output category. If not specified or if the category is not
 * understood by the client, 'console' is assumed.
 * <p>
 * Possible values include - but not limited to those defined in {@link OutputEventArgumentsCategory}
 */
@SuppressWarnings("all")
public interface OutputEventArgumentsCategory {
  /**
   * Show the output in the client's default message UI, e.g. a
   * 'debug console'. This category should only be used for informational
   * output from the debugger (as opposed to the debuggee).
   */
  static final String CONSOLE = "console";

  /**
   * A hint for the client to show the output in the client's UI
   * for important and highly visible information, e.g. as a popup
   * notification. This category should only be used for important messages
   * from the debugger (as opposed to the debuggee). Since this category value
   * is a hint, clients might ignore the hint and assume the 'console'
   * category.
   * <p>
   * Since 1.51
   */
  static final String IMPORTANT = "important";

  /**
   * Show the output as normal program output from the debuggee.
   */
  static final String STDOUT = "stdout";

  /**
   * Show the output as error program output from the debuggee.
   */
  static final String STDERR = "stderr";

  /**
   * Send the output to telemetry instead of showing it to the
   * user.
   */
  static final String TELEMETRY = "telemetry";
}
