/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentWillSaveWaitUntilTest
extends AbstractTestWithProject {
    private List<TextEdit> createSingleTextEditAtFileStart(String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(new Range(new Position(0, 0), new Position(0, newText.length())));
        textEdit.setNewText(newText);
        return List.of(textEdit);
    }

    @Test
    public void testSave() throws Exception {
        String oldText = "Hello";
        String newText = "hello";
        MockLanguageServer.INSTANCE.setWillSaveWaitUntil(this.createSingleTextEditAtFileStart("hello"));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        viewer.getDocument().replace(0, 0, "Hello");
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition("Text has not been lowercased", 2000, () -> {
            try {
                return "hello".equals(viewer.getDocument().get(0, "hello".length()));
            }
            catch (BadLocationException e) {
                return false;
            }
        });
    }
}

