/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.symbols;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Test;

public class SymbolsModelTest
extends AbstractTest {
    private final SymbolsModel symbolsModel = new SymbolsModel();

    @Test
    public void testSymbolInformationHierarchy() {
        SymbolInformation[] items = new SymbolInformation[]{this.newSymbolInformation("Namespace", SymbolKind.Namespace, this.newRange(0, 0, 10, 0)), this.newSymbolInformation("Class", SymbolKind.Class, this.newRange(1, 0, 9, 0)), this.newSymbolInformation("Method", SymbolKind.Method, this.newRange(2, 0, 8, 0))};
        this.symbolsModel_update(items);
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertEquals((Object)items[0], (Object)this.symbolsModel.getElements()[0]);
        Object[] children = this.symbolsModel.getChildren(this.symbolsModel.getElements()[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)items[1], (Object)children[0]);
        children = this.symbolsModel.getChildren(children[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)items[2], (Object)children[0]);
        Object parent = this.symbolsModel.getParent(children[0]);
        Assert.assertEquals((Object)items[1], (Object)parent);
        parent = this.symbolsModel.getParent(parent);
        Assert.assertEquals((Object)items[0], (Object)parent);
    }

    @Test
    public void testSymbolsMatchingStartingPositions() {
        SymbolInformation[] items = new SymbolInformation[]{this.newSymbolInformation("Namespace", SymbolKind.Namespace, this.newRange(0, 0, 10, 0)), this.newSymbolInformation("Class", SymbolKind.Class, this.newRange(0, 0, 9, 0)), this.newSymbolInformation("Method", SymbolKind.Method, this.newRange(1, 0, 8, 0))};
        this.symbolsModel_update(items);
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertEquals((Object)items[0], (Object)this.symbolsModel.getElements()[0]);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
        Object[] children = this.symbolsModel.getChildren(this.symbolsModel.getElements()[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)items[1], (Object)children[0]);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(children[0]));
        children = this.symbolsModel.getChildren(children[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)items[2], (Object)children[0]);
        Object parent = this.symbolsModel.getParent(children[0]);
        Assert.assertEquals((Object)items[1], (Object)parent);
        parent = this.symbolsModel.getParent(parent);
        Assert.assertEquals((Object)items[0], (Object)parent);
    }

    @Test
    public void testDuplicateSymbols() {
        Range range = this.newRange(0, 0, 0, 0);
        SymbolInformation[] items = new SymbolInformation[]{this.newSymbolInformation("Duplicate", SymbolKind.Namespace, range), this.newSymbolInformation("Duplicate", SymbolKind.Namespace, range)};
        this.symbolsModel_update(items);
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
        Assert.assertFalse((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[1]));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getChildren(this.symbolsModel.getElements()[0]).length);
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getChildren(this.symbolsModel.getElements()[1]).length);
    }

    @Test
    public void testGetElementsEmptyResponse() {
        this.symbolsModel.update(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
    }

    @Test
    public void testGetElementsNullResponse() {
        this.symbolsModel.update(null);
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
    }

    @Test
    public void testGetParentEmptyResponse() {
        this.symbolsModel.update(Collections.emptyList());
        Assert.assertEquals(null, (Object)this.symbolsModel.getParent(null));
    }

    @Test
    public void testGetParentNullResponse() {
        this.symbolsModel.update(null);
        Assert.assertEquals(null, (Object)this.symbolsModel.getParent(null));
    }

    @Test
    public void testUpdateChangeDetection_EmptyResponse() {
        Assert.assertFalse((boolean)this.symbolsModel.update(null));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel.update(Collections.emptyList()));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
    }

    @Test
    public void testUpdateChangeDetection_DocumentSymbolsResponse() {
        DocumentSymbol symbolA = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 0, 10, 0), this.newRange(0, 0, 0, 1), null);
        DocumentSymbol symbolAClone = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 0, 10, 0), this.newRange(0, 0, 0, 1), null);
        DocumentSymbol symbolB = new DocumentSymbol("B", SymbolKind.Method, this.newRange(2, 0, 2, 5), this.newRange(2, 0, 2, 1), null);
        DocumentSymbol symbolBClone = new DocumentSymbol("B", SymbolKind.Method, this.newRange(2, 0, 2, 5), this.newRange(2, 0, 2, 1), null);
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.update(Collections.emptyList()));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel.update(Collections.emptyList()));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA, symbolB));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolAClone, symbolBClone));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolB, symbolA));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        DocumentSymbol symbolAShift = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 1, 10, 1), this.newRange(0, 1, 0, 2), null);
        DocumentSymbol symbolBShift = new DocumentSymbol("B", SymbolKind.Method, this.newRange(2, 1, 2, 6), this.newRange(2, 1, 2, 2), null);
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolAShift, symbolBShift));
        DocumentSymbol symbolAShift2 = new DocumentSymbol("A", SymbolKind.Class, symbolBShift.getRange(), symbolBShift.getSelectionRange(), null);
        DocumentSymbol symbolBShift2 = new DocumentSymbol("B", SymbolKind.Method, symbolAShift.getRange(), symbolAShift.getSelectionRange(), null);
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolAShift2, symbolBShift2));
        this.symbolsModel.setUri(URI.create("file://test"));
        DocumentSymbol symbolBAsChild = new DocumentSymbol("B", SymbolKind.Method, this.newRange(0, 2, 0, 4), this.newRange(0, 2, 0, 3), null);
        DocumentSymbol symbolAWithChildB = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 0, 10, 0), this.newRange(0, 0, 0, 1));
        symbolAWithChildB.setChildren(List.of(symbolBAsChild));
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolAWithChildB));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
        DocumentSymbol symbolBAsChildClone = new DocumentSymbol("B", SymbolKind.Method, this.newRange(0, 2, 0, 4), this.newRange(0, 2, 0, 3), null);
        DocumentSymbol symbolAWithChildBClone = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 0, 10, 0), this.newRange(0, 0, 0, 1));
        symbolAWithChildBClone.setChildren(List.of(symbolBAsChildClone));
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolAWithChildBClone));
        DocumentSymbol symbolC = new DocumentSymbol("C", SymbolKind.Method, this.newRange(0, 2, 0, 4), this.newRange(0, 2, 0, 3), null);
        DocumentSymbol symbolAWithChildC = new DocumentSymbol("A", SymbolKind.Class, this.newRange(0, 0, 10, 0), this.newRange(0, 0, 0, 1));
        symbolAWithChildC.setChildren(List.of(symbolC));
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolAWithChildC));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
    }

    @Test
    public void testUpdateChangeDetection_SymbolInformationResponse() {
        SymbolInformation symbolA = this.newSymbolInformation("A", SymbolKind.Class, this.newRange(0, 0, 0, 10));
        SymbolInformation symbolAClone = this.newSymbolInformation("A", SymbolKind.Class, this.newRange(0, 0, 0, 10));
        SymbolInformation symbolB = this.newSymbolInformation("B", SymbolKind.Method, this.newRange(2, 0, 2, 5));
        SymbolInformation symbolBClone = this.newSymbolInformation("B", SymbolKind.Method, this.newRange(2, 0, 2, 5));
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.update(Collections.emptyList()));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel.update(Collections.emptyList()));
        Assert.assertEquals((long)0L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA, symbolB));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolA, symbolB));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolAClone, symbolBClone));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolB, symbolA));
        Assert.assertEquals((long)2L, (long)this.symbolsModel.getElements().length);
        SymbolInformation symbolBAsChild = this.newSymbolInformation("B", SymbolKind.Method, this.newRange(0, 2, 0, 4));
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA, symbolBAsChild));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
        Assert.assertFalse((boolean)this.symbolsModel_update(symbolAClone, symbolBAsChild));
        SymbolInformation symbolCAsChild = this.newSymbolInformation("C", SymbolKind.Method, this.newRange(0, 2, 0, 4));
        Assert.assertTrue((boolean)this.symbolsModel_update(symbolA, symbolCAsChild));
        Assert.assertEquals((long)1L, (long)this.symbolsModel.getElements().length);
        Assert.assertTrue((boolean)this.symbolsModel.hasChildren(this.symbolsModel.getElements()[0]));
    }

    private boolean symbolsModel_update(DocumentSymbol ... symbols) {
        return this.symbolsModel.update(Arrays.stream(symbols).map(sym -> Either.forRight((Object)sym)).toList());
    }

    private boolean symbolsModel_update(SymbolInformation ... symbols) {
        return this.symbolsModel.update(Arrays.stream(symbols).map(sym -> Either.forLeft((Object)sym)).toList());
    }

    private Range newRange(int startLine, int startChar, int endLine, int endChar) {
        return new Range(new Position(startLine, startChar), new Position(endLine, endChar));
    }

    private SymbolInformation newSymbolInformation(String name, SymbolKind kind, Range range) {
        SymbolInformation symbolInformation = new SymbolInformation();
        symbolInformation.setName(name);
        symbolInformation.setKind(kind);
        symbolInformation.setLocation(new Location("file://test", range));
        return symbolInformation;
    }
}

