/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ImageConfig;
import org.mandas.docker.client.messages.ImageInfo;
import org.mandas.docker.client.messages.RootFs;

final class ImmutableImageInfo
implements ImageInfo {
    private final String id;
    @Nullable
    private final String parent;
    @Nullable
    private final String comment;
    private final Date created;
    @Nullable
    private final String container;
    @Nullable
    private final ContainerConfig containerConfig;
    @Nullable
    private final String dockerVersion;
    @Nullable
    private final String author;
    private final ImageConfig config;
    private final String architecture;
    private final String os;
    private final Long size;
    @Nullable
    private final RootFs rootFs;

    private ImmutableImageInfo(String id, @Nullable String parent, @Nullable String comment, Date created, @Nullable String container, @Nullable ContainerConfig containerConfig, @Nullable String dockerVersion, @Nullable String author, ImageConfig config, String architecture, String os, Long size, @Nullable RootFs rootFs) {
        this.id = id;
        this.parent = parent;
        this.comment = comment;
        this.created = created;
        this.container = container;
        this.containerConfig = containerConfig;
        this.dockerVersion = dockerVersion;
        this.author = author;
        this.config = config;
        this.architecture = architecture;
        this.os = os;
        this.size = size;
        this.rootFs = rootFs;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Parent")
    @Deprecated
    @Nullable
    public String parent() {
        return this.parent;
    }

    @Override
    @JsonProperty(value="Comment")
    @Deprecated
    @Nullable
    public String comment() {
        return this.comment;
    }

    @Override
    @JsonProperty(value="Created")
    public Date created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="Container")
    @Deprecated
    @Nullable
    public String container() {
        return this.container;
    }

    @Override
    @JsonProperty(value="ContainerConfig")
    @Deprecated
    @Nullable
    public ContainerConfig containerConfig() {
        return this.containerConfig;
    }

    @Override
    @JsonProperty(value="DockerVersion")
    @Deprecated
    @Nullable
    public String dockerVersion() {
        return this.dockerVersion;
    }

    @Override
    @JsonProperty(value="Author")
    @Deprecated
    @Nullable
    public String author() {
        return this.author;
    }

    @Override
    @JsonProperty(value="Config")
    public ImageConfig config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="Architecture")
    public String architecture() {
        return this.architecture;
    }

    @Override
    @JsonProperty(value="Os")
    public String os() {
        return this.os;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="RootFS")
    @Nullable
    public RootFs rootFs() {
        return this.rootFs;
    }

    public final ImmutableImageInfo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(newValue, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withParent(@Nullable String value) {
        if (Objects.equals(this.parent, value)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, value, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withComment(@Nullable String value) {
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, value, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    public final ImmutableImageInfo withCreated(Date value) {
        if (this.created == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "created");
        return new ImmutableImageInfo(this.id, this.parent, this.comment, newValue, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withContainer(@Nullable String value) {
        if (Objects.equals(this.container, value)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, value, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withContainerConfig(@Nullable ContainerConfig value) {
        if (this.containerConfig == value) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, value, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withDockerVersion(@Nullable String value) {
        if (Objects.equals(this.dockerVersion, value)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, value, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    @Deprecated
    public final ImmutableImageInfo withAuthor(@Nullable String value) {
        if (Objects.equals(this.author, value)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, value, this.config, this.architecture, this.os, this.size, this.rootFs);
    }

    public final ImmutableImageInfo withConfig(ImageConfig value) {
        if (this.config == value) {
            return this;
        }
        ImageConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, newValue, this.architecture, this.os, this.size, this.rootFs);
    }

    public final ImmutableImageInfo withArchitecture(String value) {
        String newValue = Objects.requireNonNull(value, "architecture");
        if (this.architecture.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, newValue, this.os, this.size, this.rootFs);
    }

    public final ImmutableImageInfo withOs(String value) {
        String newValue = Objects.requireNonNull(value, "os");
        if (this.os.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, newValue, this.size, this.rootFs);
    }

    public final ImmutableImageInfo withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, newValue, this.rootFs);
    }

    public final ImmutableImageInfo withRootFs(@Nullable RootFs value) {
        if (this.rootFs == value) {
            return this;
        }
        return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageInfo && this.equalsByValue((ImmutableImageInfo)another);
    }

    private boolean equalsByValue(ImmutableImageInfo another) {
        return this.id.equals(another.id) && Objects.equals(this.parent, another.parent) && Objects.equals(this.comment, another.comment) && this.created.equals(another.created) && Objects.equals(this.container, another.container) && Objects.equals(this.containerConfig, another.containerConfig) && Objects.equals(this.dockerVersion, another.dockerVersion) && Objects.equals(this.author, another.author) && this.config.equals(another.config) && this.architecture.equals(another.architecture) && this.os.equals(another.os) && this.size.equals(another.size) && Objects.equals(this.rootFs, another.rootFs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + Objects.hashCode(this.comment);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.container);
        h += (h << 5) + Objects.hashCode(this.containerConfig);
        h += (h << 5) + Objects.hashCode(this.dockerVersion);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.architecture.hashCode();
        h += (h << 5) + this.os.hashCode();
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + Objects.hashCode(this.rootFs);
        return h;
    }

    public String toString() {
        return "ImageInfo{id=" + this.id + ", parent=" + this.parent + ", comment=" + this.comment + ", created=" + String.valueOf(this.created) + ", container=" + this.container + ", containerConfig=" + String.valueOf(this.containerConfig) + ", dockerVersion=" + this.dockerVersion + ", author=" + this.author + ", config=" + String.valueOf(this.config) + ", architecture=" + this.architecture + ", os=" + this.os + ", size=" + this.size + ", rootFs=" + String.valueOf(this.rootFs) + "}";
    }

    public static ImmutableImageInfo copyOf(ImageInfo instance) {
        if (instance instanceof ImmutableImageInfo) {
            return (ImmutableImageInfo)instance;
        }
        return ImmutableImageInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_CONFIG = 4L;
        private static final long INIT_BIT_ARCHITECTURE = 8L;
        private static final long INIT_BIT_OS = 16L;
        private static final long INIT_BIT_SIZE = 32L;
        private long initBits = 63L;
        private String id;
        private String parent;
        private String comment;
        private Date created;
        private String container;
        private ContainerConfig containerConfig;
        private String dockerVersion;
        private String author;
        private ImageConfig config;
        private String architecture;
        private String os;
        private Long size;
        private RootFs rootFs;

        private Builder() {
        }

        public final Builder from(ImageInfo instance) {
            String authorValue;
            String dockerVersionValue;
            ContainerConfig containerConfigValue;
            String commentValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            String parentValue = instance.parent();
            if (parentValue != null) {
                this.parent(parentValue);
            }
            if ((commentValue = instance.comment()) != null) {
                this.comment(commentValue);
            }
            this.created(instance.created());
            String containerValue = instance.container();
            if (containerValue != null) {
                this.container(containerValue);
            }
            if ((containerConfigValue = instance.containerConfig()) != null) {
                this.containerConfig(containerConfigValue);
            }
            if ((dockerVersionValue = instance.dockerVersion()) != null) {
                this.dockerVersion(dockerVersionValue);
            }
            if ((authorValue = instance.author()) != null) {
                this.author(authorValue);
            }
            this.config(instance.config());
            this.architecture(instance.architecture());
            this.os(instance.os());
            this.size(instance.size());
            RootFs rootFsValue = instance.rootFs();
            if (rootFsValue != null) {
                this.rootFs(rootFsValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Parent")
        @Deprecated
        public final Builder parent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        @JsonProperty(value="Comment")
        @Deprecated
        public final Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(Date created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Container")
        @Deprecated
        public final Builder container(@Nullable String container) {
            this.container = container;
            return this;
        }

        @JsonProperty(value="ContainerConfig")
        @Deprecated
        public final Builder containerConfig(@Nullable ContainerConfig containerConfig) {
            this.containerConfig = containerConfig;
            return this;
        }

        @JsonProperty(value="DockerVersion")
        @Deprecated
        public final Builder dockerVersion(@Nullable String dockerVersion) {
            this.dockerVersion = dockerVersion;
            return this;
        }

        @JsonProperty(value="Author")
        @Deprecated
        public final Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        @JsonProperty(value="Config")
        public final Builder config(ImageConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Architecture")
        public final Builder architecture(String architecture) {
            this.architecture = Objects.requireNonNull(architecture, "architecture");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Os")
        public final Builder os(String os) {
            this.os = Objects.requireNonNull(os, "os");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Size")
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="RootFS")
        public final Builder rootFs(@Nullable RootFs rootFs) {
            this.rootFs = rootFs;
            return this;
        }

        public ImmutableImageInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageInfo(this.id, this.parent, this.comment, this.created, this.container, this.containerConfig, this.dockerVersion, this.author, this.config, this.architecture, this.os, this.size, this.rootFs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("architecture");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("os");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build ImageInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

