/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerUlimit;
import org.mandas.docker.client.messages.HostConfig;

public class DockerUlimit
implements IDockerUlimit {
    private final String name;
    private final Long soft;
    private final Long hard;

    public DockerUlimit(HostConfig.Ulimit ulimit) {
        this.name = ulimit.name();
        this.soft = ulimit.soft();
        this.hard = ulimit.hard();
    }

    private DockerUlimit(Builder builder) {
        this.name = builder.name;
        this.soft = builder.soft;
        this.hard = builder.hard;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long soft() {
        return this.soft;
    }

    @Override
    public Long hard() {
        return this.hard;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Long soft;
        private Long hard;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder soft(Long soft) {
            this.soft = soft;
            return this;
        }

        public Builder hard(Long hard) {
            this.hard = hard;
            return this;
        }

        public IDockerUlimit build() {
            return new DockerUlimit(this);
        }
    }
}

