/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.extensions.references.settings.XMLReferenceExpression;
import org.eclipse.lemminx.extensions.references.settings.XMLReferences;
import org.eclipse.lemminx.extensions.references.settings.XMLReferencesSettings;

public class XMLReferencesSettingsForTest {
    public static XMLReferencesSettings createXMLReferencesSettings() {
        XMLReferencesSettings referencesSettings = new XMLReferencesSettings();
        referencesSettings.setReferences(XMLReferencesSettingsForTest.createReferences());
        return referencesSettings;
    }

    private static List<XMLReferences> createReferences() {
        ArrayList<XMLReferences> references = new ArrayList<XMLReferences>();
        XMLReferences tei = new XMLReferences();
        tei.setPattern("**/*tei.xml");
        references.add(tei);
        XMLReferenceExpression corresp = new XMLReferenceExpression();
        corresp.setPrefix("#");
        corresp.setFrom("@corresp");
        corresp.setTo("@xml:id");
        XMLReferenceExpression target = new XMLReferenceExpression();
        target.setPrefix("#");
        target.setFrom("@target");
        target.setTo("@xml:id");
        target.setMultiple(Boolean.valueOf(true));
        tei.setExpressions(Arrays.asList(corresp, target));
        XMLReferences docbook = new XMLReferences();
        docbook.setPattern("**/*docbook.xml");
        XMLReferenceExpression linkend = new XMLReferenceExpression();
        linkend.setFrom("xref/@linkend");
        linkend.setTo("@id");
        docbook.setExpressions(Arrays.asList(linkend));
        references.add(docbook);
        XMLReferences web = new XMLReferences();
        web.setPattern("**/web.xml");
        XMLReferenceExpression servletName = new XMLReferenceExpression();
        servletName.setFrom("servlet-mapping/servlet-name/text()");
        servletName.setTo("servlet/servlet-name/text()");
        web.setExpressions(Arrays.asList(servletName));
        references.add(web);
        XMLReferences attrToText = new XMLReferences();
        attrToText.setPattern("**/attr-to-text.xml");
        XMLReferenceExpression attrToTextExpr = new XMLReferenceExpression();
        attrToTextExpr.setFrom("@ref");
        attrToTextExpr.setTo("bbb/text()");
        attrToTextExpr.setMultiple(Boolean.valueOf(true));
        attrToText.setExpressions(Arrays.asList(attrToTextExpr));
        references.add(attrToText);
        XMLReferences textToText = new XMLReferences();
        textToText.setPattern("**/text-to-text.xml");
        XMLReferenceExpression textToTextExpr = new XMLReferenceExpression();
        textToTextExpr.setFrom("from/text()");
        textToTextExpr.setTo("to/text()");
        textToTextExpr.setMultiple(Boolean.valueOf(true));
        textToText.setExpressions(Arrays.asList(textToTextExpr));
        references.add(textToText);
        return references;
    }
}

