/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDContentModelProvider;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDContentModelProvider;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContentModelManagerDependsOnGrammarTest
extends AbstractCacheBasedTest {
    private ContentModelManager modelManager;

    @BeforeEach
    public void setup() {
        URIResolverExtensionManager resolverExtensionManager = new URIResolverExtensionManager();
        this.modelManager = new ContentModelManager(resolverExtensionManager);
        CMDTDContentModelProvider modelProvider = new CMDTDContentModelProvider(resolverExtensionManager);
        this.modelManager.registerModelProvider((ContentModelProvider)modelProvider);
        modelProvider = new CMXSDContentModelProvider(resolverExtensionManager);
        this.modelManager.registerModelProvider((ContentModelProvider)modelProvider);
    }

    @Test
    public void dependsOnGrammarTrue1WithNamespace() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n\t\t xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\t\t xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 /home/nikolas/testXSD.xsd\">\r\n";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrue2WithNamespace() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n\t\t xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n\t\t xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 nested/testXSD.xsd\">\r\n";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/nested/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrue3WithNamespace() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 file:///home/nikolas/nested/testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/nested/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrue1NoNamespace() {
        String text = "<project \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"testXSD.xsd\"> ";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrue2NoNamespace() {
        String text = "<project \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"nested/testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/nested/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrue3NoNamespace() {
        String text = "<project \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"file:///home/nikolas/nested/testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/nested/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarFalseWithNamespace() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertFalse((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/NOT_NIKOLAS/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarFalseNoNamespace() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"nested/testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertFalse((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/NOT_NIKOLAS/nested/testXSD.xsd"));
    }

    @Test
    public void dependsOnGrammarTrueAbsolutePath() {
        String text = "<project \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"/home/nikolas/nested/testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/nikolas/testXML.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertTrue((boolean)d.hasSchemaInstancePrefix());
        Assertions.assertTrue((boolean)this.modelManager.dependsOnGrammar(d, "file:///home/nikolas/nested/testXSD.xsd"));
    }

    @Test
    public void testNoNamespaceSchemaLocationAndSchemaLocationBoth() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" \r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:noNamespaceSchemaLocation=\"/home/nikolas/nested/testXSD.xsd\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 testXSD.xsd\">";
        TextDocument textDocument = new TextDocument(text, "/home/test.xml");
        DOMDocument d = DOMParser.getInstance().parse(text, textDocument.getUri(), null);
        Assertions.assertNotNull((Object)d.getNoNamespaceSchemaLocation());
        Assertions.assertNotNull((Object)d.getSchemaLocation());
    }
}

