/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.uriresolver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.LSPXMLCatalogResolver;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;
import org.eclipse.lemminx.utils.FilesUtils;

public class XMLCatalogResolverExtension
implements URIResolverExtension {
    private static final Logger LOGGER = Logger.getLogger(XMLCatalogResolverExtension.class.getName());
    private LSPXMLCatalogResolver catalogResolver;
    private String rootUri;

    @Override
    public String getName() {
        return "catalog";
    }

    @Override
    public String resolve(String baseURI, String publicId, String systemId) {
        if (this.catalogResolver != null) {
            String namespaceURI = publicId;
            return this.catalogResolver.resolveIdentifier(namespaceURI, publicId, systemId, baseURI);
        }
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        if (this.catalogResolver != null) {
            return this.catalogResolver.resolveEntity(resourceIdentifier);
        }
        return null;
    }

    public void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    public boolean setCatalogs(String[] catalogs) {
        String[] oldCatalogs;
        String[] stringArray = oldCatalogs = this.catalogResolver != null ? this.catalogResolver.getCatalogList() : null;
        if (catalogs != null) {
            ArrayList<String> xmlCatalogFiles = new ArrayList<String>();
            for (String catalogPath : catalogs) {
                String fullPath = this.expandSystemId(catalogPath);
                if (Files.exists(FilesUtils.getPath(fullPath), new LinkOption[0])) {
                    xmlCatalogFiles.add(fullPath);
                    LOGGER.info("Adding XML catalog '" + catalogPath + "' with expand system id '" + fullPath + "' and root URI '" + this.rootUri + "'.");
                    continue;
                }
                LOGGER.severe("Cannot add XML catalog '" + catalogPath + "' with expand system id '" + fullPath + "' and root URI '" + this.rootUri + "'.");
            }
            if (xmlCatalogFiles.size() > 0) {
                LSPXMLCatalogResolver catalogResolver = new LSPXMLCatalogResolver(xmlCatalogFiles.toArray(new String[0]));
                this.setCatalogResolver(catalogResolver);
            } else {
                this.setCatalogResolver(null);
            }
        } else {
            this.setCatalogResolver(null);
        }
        String[] newCatalogs = this.catalogResolver != null ? this.catalogResolver.getCatalogList() : null;
        return !Objects.equals(oldCatalogs, newCatalogs);
    }

    public String expandSystemId(String path) {
        try {
            return XMLEntityManager.expandSystemId((String)path, (String)this.rootUri, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return path;
        }
    }

    private void setCatalogResolver(LSPXMLCatalogResolver catalogResolver) {
        this.catalogResolver = catalogResolver;
    }

    public void refreshCatalogs() {
        if (this.catalogResolver != null) {
            this.setCatalogs(this.catalogResolver.getCatalogList());
        }
    }

    public String[] getCatalogs() {
        if (this.catalogResolver != null) {
            return this.catalogResolver.getCatalogList();
        }
        return null;
    }
}

