/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMCommentFormatter {
    private final XMLFormatterDocument formatterDocument;

    public DOMCommentFormatter(XMLFormatterDocument formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatComment(DOMComment commentNode, XMLFormattingConstraints parentConstraints, int startRange, int endRange, List<TextEdit> edits) {
        int leftWhitespaceOffset;
        if (commentNode.getEnd() == commentNode.getEndContent()) {
            return;
        }
        String text = this.formatterDocument.getText();
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int start = commentNode.getStart();
        int n = leftWhitespaceOffset = start > 0 ? start - 1 : 0;
        while (leftWhitespaceOffset > 0 && Character.isWhitespace(text.charAt(leftWhitespaceOffset))) {
            --leftWhitespaceOffset;
        }
        int indentLevel = parentConstraints.getIndentLevel();
        int tabSize = this.getTabSize();
        int maxLineWidth = this.getMaxLineWidth();
        if (this.formatterDocument.hasLineBreak(leftWhitespaceOffset, start) && startRange < start) {
            this.replaceLeftSpacesWithIndentationPreservedNewLines(0, start, indentLevel, edits);
            availableLineWidth = maxLineWidth - tabSize * indentLevel;
        }
        int spaceStart = -1;
        int spaceEnd = -1;
        availableLineWidth -= 4;
        int whiteSpaceOffset = -1;
        for (int i = commentNode.getStartContent(); i < commentNode.getEndContent(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (DOMCommentFormatter.isLineSeparator(c) && !this.isJoinCommentLines()) {
                    availableLineWidth = maxLineWidth;
                }
                whiteSpaceOffset = i;
                if (spaceStart == -1) {
                    spaceStart = i;
                    continue;
                }
                spaceEnd = i;
                continue;
            }
            spaceEnd = i;
            if (startRange != -1 && endRange != -1 && (startRange > spaceStart || endRange < spaceEnd)) {
                return;
            }
            int contentStart = i;
            while (i + 1 < commentNode.getEnd() && !Character.isWhitespace(text.charAt(i + 1))) {
                ++i;
            }
            int contentEnd = i + 1;
            if (this.isMaxLineWidthSupported()) {
                availableLineWidth = commentNode.getStartContent() != contentStart && this.isJoinCommentLines() && availableLineWidth >= 0 ? --availableLineWidth : (availableLineWidth -= spaceEnd - whiteSpaceOffset);
                if ((availableLineWidth -= contentEnd - contentStart) < 0 && spaceStart != -1) {
                    this.replaceLeftSpacesWithIndentation(indentLevel, spaceStart, contentStart, true, edits);
                    int indentSpaces = tabSize * indentLevel;
                    availableLineWidth = maxLineWidth - indentSpaces - (contentEnd - contentStart);
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
            }
            if (this.isJoinCommentLines()) {
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd - 1, edits);
            }
            spaceStart = -1;
            spaceEnd = -1;
        }
        if (this.isJoinCommentLines()) {
            this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
            if (this.isMaxLineWidthSupported()) {
                parentConstraints.setAvailableLineWidth(--availableLineWidth);
            }
        }
    }

    private boolean isJoinCommentLines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinCommentLines();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private boolean isMaxLineWidthSupported() {
        return this.formatterDocument.isMaxLineWidthSupported();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private void replaceLeftSpacesWithIndentationPreservedNewLines(int spaceStart, int spaceEnd, int indentLevel, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithIndentationPreservedNewLines(spaceStart, spaceEnd, indentLevel, edits);
    }

    private static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }
}

