/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.DOMDocTypeFormatter;
import org.eclipse.lemminx.services.format.DOMElementFormatter;
import org.eclipse.lemminx.services.format.DOMProcessingInstructionFormatter;
import org.eclipse.lemminx.services.format.DOMTextFormatter;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.TextEditUtils;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Text;

public class XMLFormatterDocumentNew {
    private static final Logger LOGGER = Logger.getLogger(XMLFormatterDocumentNew.class.getName());
    private static final String XML_SPACE_ATTR = "xml:space";
    private static final String XML_SPACE_ATTR_DEFAULT = "default";
    private static final String XML_SPACE_ATTR_PRESERVE = "preserve";
    private final DOMDocument xmlDocument;
    private final TextDocument textDocument;
    private final String lineDelimiter;
    private final SharedSettings sharedSettings;
    private final DOMProcessingInstructionFormatter processingInstructionFormatter;
    private final DOMDocTypeFormatter docTypeFormatter;
    private final DOMElementFormatter elementFormatter;
    private final DOMAttributeFormatter attributeFormatter;
    private final DOMTextFormatter textFormatter;
    private final Collection<IFormatterParticipant> formatterParticipants;
    private int startOffset = -1;
    private int endOffset = -1;
    private CancelChecker cancelChecker;

    public XMLFormatterDocumentNew(DOMDocument xmlDocument, Range range, SharedSettings sharedSettings, Collection<IFormatterParticipant> formatterParticipants) {
        this.xmlDocument = xmlDocument;
        this.textDocument = xmlDocument.getTextDocument();
        this.lineDelimiter = XMLFormatterDocumentNew.computeLineDelimiter(this.textDocument);
        if (range != null) {
            try {
                this.startOffset = this.textDocument.offsetAt(range.getStart());
                this.endOffset = this.textDocument.offsetAt(range.getEnd());
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.sharedSettings = sharedSettings;
        this.formatterParticipants = formatterParticipants;
        this.docTypeFormatter = new DOMDocTypeFormatter(this);
        this.attributeFormatter = new DOMAttributeFormatter(this);
        this.elementFormatter = new DOMElementFormatter(this, this.attributeFormatter);
        this.processingInstructionFormatter = new DOMProcessingInstructionFormatter(this, this.attributeFormatter);
        this.textFormatter = new DOMTextFormatter(this);
    }

    private static String computeLineDelimiter(TextDocument textDocument) {
        try {
            return textDocument.lineDelimiter(0);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return System.lineSeparator();
        }
    }

    public List<? extends TextEdit> format() throws BadLocationException {
        return this.format(this.xmlDocument, this.startOffset, this.endOffset);
    }

    public List<? extends TextEdit> format(DOMDocument document, int start, int end) {
        char c;
        String xml;
        int endDocument;
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        DOMNode currentDOMNode = XMLFormatterDocumentNew.getDOMNodeToFormat(document, start, end);
        if (currentDOMNode != null) {
            int startOffset = currentDOMNode.getStart();
            XMLFormattingConstraints parentConstraints = this.getNodeConstraints(currentDOMNode);
            int lineWidth = this.getMaxLineWidth();
            try {
                int lineOffset = this.textDocument.lineOffsetAt(startOffset);
                lineWidth -= startOffset - lineOffset;
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            parentConstraints.setAvailableLineWidth(lineWidth);
            if (currentDOMNode.isElement()) {
                parentConstraints.setFormatElementCategory(this.getFormatElementCategory((DOMElement)currentDOMNode, null));
            } else {
                parentConstraints.setFormatElementCategory(FormatElementCategory.IgnoreSpace);
            }
            this.formatSiblings(edits, currentDOMNode, parentConstraints, start, end);
        }
        boolean insertFinalNewline = this.isInsertFinalNewline();
        if (this.isTrimFinalNewlines()) {
            this.trimFinalNewlines(insertFinalNewline, edits);
        }
        if (insertFinalNewline && (endDocument = (xml = this.textDocument.getText()).length() - 1) >= 0 && (c = xml.charAt(endDocument)) != '\n') {
            try {
                Position pos = this.textDocument.positionAt(endDocument);
                pos.setCharacter(pos.getCharacter() + 1);
                Range range = new Range(pos, pos);
                edits.add(new TextEdit(range, this.lineDelimiter));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return edits;
    }

    private static DOMNode getDOMNodeToFormat(DOMDocument document, int start, int end) {
        if (start != -1 && end != -1) {
            DOMNode startNode = document.findNodeAt(start);
            DOMNode endNode = document.findNodeBefore(end);
            if (endNode.getStart() == start) {
                return endNode;
            }
            if (XMLFormatterDocumentNew.isCoverNode(startNode, endNode)) {
                return startNode;
            }
            if (XMLFormatterDocumentNew.isCoverNode(endNode, startNode)) {
                return endNode;
            }
            DOMNode startParent = startNode.getParentNode();
            for (DOMNode endParent = endNode.getParentNode(); startParent != null && endParent != null; startParent = startParent.getParentNode(), endParent = endParent.getParentNode()) {
                if (XMLFormatterDocumentNew.isCoverNode(startParent, endParent)) {
                    return startParent;
                }
                if (!XMLFormatterDocumentNew.isCoverNode(endParent, startParent)) continue;
                return endParent;
            }
        }
        return document;
    }

    private static boolean isCoverNode(DOMNode startNode, DOMNode endNode) {
        return startNode.getStart() < endNode.getStart() && startNode.getEnd() > endNode.getEnd() || startNode == endNode;
    }

    private XMLFormattingConstraints getNodeConstraints(DOMNode node) {
        XMLFormattingConstraints result = new XMLFormattingConstraints();
        int indentLevel = 0;
        while (node != null) {
            if ((node = node.getParentElement()) == null) continue;
            ++indentLevel;
        }
        result.setIndentLevel(indentLevel);
        return result;
    }

    private void formatSiblings(List<TextEdit> edits, DOMNode domNode, XMLFormattingConstraints parentConstraints, int start, int end) {
        for (DOMNode currentDOMNode = domNode; currentDOMNode != null; currentDOMNode = currentDOMNode.getNextSibling()) {
            if (this.cancelChecker != null) {
                this.cancelChecker.checkCanceled();
            }
            this.format(currentDOMNode, parentConstraints, start, end, edits);
        }
    }

    private void format(DOMNode child, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        switch (child.getNodeType()) {
            case 10: {
                DOMDocumentType docType = (DOMDocumentType)child;
                this.docTypeFormatter.formatDocType(docType, parentConstraints, start, end, edits);
                break;
            }
            case 9: {
                DOMDocument document = (DOMDocument)child;
                this.formatChildren(document, parentConstraints, start, end, edits);
                break;
            }
            case 7: {
                DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)child;
                this.processingInstructionFormatter.formatProcessingInstruction(processingInstruction, parentConstraints, edits);
                break;
            }
            case 1: {
                DOMElement element = (DOMElement)child;
                this.elementFormatter.formatElement(element, parentConstraints, start, end, edits);
                break;
            }
            case 3: {
                DOMText textNode = (DOMText)child;
                this.textFormatter.formatText(textNode, parentConstraints, edits);
                break;
            }
            default: {
                int width = this.updateLineWidthWithLastLine(child, parentConstraints.getAvailableLineWidth());
                parentConstraints.setAvailableLineWidth(width);
            }
        }
    }

    public void formatChildren(DOMNode currentDOMNode, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        for (DOMNode child : currentDOMNode.getChildren()) {
            this.format(child, parentConstraints, start, end, edits);
        }
    }

    void removeLeftSpaces(int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(to, "", edits);
    }

    void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(from, to, "", edits);
    }

    void replaceLeftSpacesWithOneSpace(int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(to, " ", edits);
    }

    void replaceLeftSpacesWithOneSpace(int from, int to, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(from, to, " ", edits);
    }

    void replaceLeftSpacesWith(int to, String replacement, List<TextEdit> edits) {
        this.replaceLeftSpacesWith(-1, to, replacement, edits);
    }

    void replaceLeftSpacesWith(int leftLimit, int to, String replacement, List<TextEdit> edits) {
        int from = this.getLeftWhitespacesOffset(leftLimit, to);
        this.createTextEditIfNeeded(from, to, replacement, edits);
    }

    private int getLeftWhitespacesOffset(int leftLimit, int to) {
        String text = this.textDocument.getText();
        int from = leftLimit != -1 ? leftLimit : to - 1;
        int limit = leftLimit != -1 ? leftLimit : 0;
        for (int i = to - 1; i >= limit; --i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            from = i;
            break;
        }
        return from;
    }

    int replaceLeftSpacesWithIndentation(int indentLevel, int offset, boolean addLineSeparator, List<TextEdit> edits) {
        int start = offset - 1;
        if (start > 0) {
            String expectedSpaces = this.getIndentSpaces(indentLevel, addLineSeparator);
            this.createTextEditIfNeeded(start, offset, expectedSpaces, edits);
            return expectedSpaces.length();
        }
        return 0;
    }

    boolean hasLineBreak(int startAttr, int start) {
        String text = this.textDocument.getText();
        for (int i = startAttr; i < start; ++i) {
            char c = text.charAt(i);
            if (!XMLFormatterDocumentNew.isLineSeparator(c)) continue;
            return true;
        }
        return false;
    }

    int updateLineWidthWithLastLine(DOMNode child, int availableLineWidth) {
        char c;
        String text = this.textDocument.getText();
        int lineWidth = availableLineWidth;
        int end = child.getEnd();
        if (end < text.length() && XMLFormatterDocumentNew.isLineSeparator(c = text.charAt(end))) {
            return this.getMaxLineWidth();
        }
        for (int i = end - 1; i > child.getStart(); --i) {
            char c2 = text.charAt(i);
            if (XMLFormatterDocumentNew.isLineSeparator(c2)) {
                return lineWidth;
            }
            --lineWidth;
        }
        return lineWidth;
    }

    private static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    void insertLineBreak(int start, int end, List<TextEdit> edits) {
        this.createTextEditIfNeeded(start, end, this.lineDelimiter, edits);
    }

    void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        if (spaceStart >= 0) {
            spaceEnd = spaceEnd == -1 ? spaceStart + 1 : spaceEnd + 1;
            this.replaceLeftSpacesWithOneSpace(spaceStart, spaceEnd, edits);
        }
    }

    public FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints) {
        if (!element.isClosed()) {
            return parentConstraints.getFormatElementCategory();
        }
        FormatElementCategory fromSettings = this.sharedSettings.getFormattingSettings().getFormatElementCategory(element);
        if (fromSettings != null) {
            return fromSettings;
        }
        for (IFormatterParticipant participant : this.formatterParticipants) {
            FormatElementCategory fromParticipant = participant.getFormatElementCategory(element, parentConstraints, this.sharedSettings);
            if (fromParticipant == null) continue;
            return fromParticipant;
        }
        if (XML_SPACE_ATTR_PRESERVE.equals(element.getAttribute(XML_SPACE_ATTR))) {
            return FormatElementCategory.PreserveSpace;
        }
        if (parentConstraints != null && parentConstraints.getFormatElementCategory() == FormatElementCategory.PreserveSpace && !XML_SPACE_ATTR_DEFAULT.equals(element.getAttribute(XML_SPACE_ATTR))) {
            return FormatElementCategory.PreserveSpace;
        }
        boolean hasElement = false;
        boolean hasText = false;
        boolean onlySpaces = true;
        for (DOMNode child : element.getChildren()) {
            if (child.isElement()) {
                hasElement = true;
            } else if (child.isText() && !(onlySpaces = ((Text)((Object)child)).isElementContentWhitespace())) {
                hasText = true;
            }
            if (!hasElement || !hasText) continue;
            return FormatElementCategory.MixedContent;
        }
        if (hasElement && onlySpaces) {
            return FormatElementCategory.IgnoreSpace;
        }
        return FormatElementCategory.NormalizeSpace;
    }

    void createTextEditIfNeeded(int from, int to, String expectedContent, List<TextEdit> edits) {
        TextEdit edit = TextEditUtils.createTextEditIfNeeded(from, to, expectedContent, this.textDocument);
        if (edit != null) {
            edits.add(edit);
        }
    }

    private String getIndentSpaces(int level, boolean addLineSeparator) {
        StringBuilder spaces = new StringBuilder();
        if (addLineSeparator) {
            spaces.append(this.lineDelimiter);
        }
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    spaces.append(" ");
                }
                continue;
            }
            spaces.append("\t");
        }
        return spaces.toString();
    }

    private void trimFinalNewlines(boolean insertFinalNewline, List<TextEdit> edits) {
        int end;
        int i;
        String xml = this.textDocument.getText();
        for (i = end = xml.length() - 1; i >= 0 && XMLFormatterDocumentNew.isLineSeparator(xml.charAt(i)); --i) {
        }
        if (end > i) {
            if (insertFinalNewline) {
                ++i;
                if (xml.charAt(end - 1) == '\r') {
                    ++i;
                }
            }
            if (end > i) {
                try {
                    Position endPos = this.textDocument.positionAt(end + 1);
                    Position startPos = this.textDocument.positionAt(i + 1);
                    Range range = new Range(startPos, endPos);
                    edits.add(new TextEdit(range, ""));
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    int getMaxLineWidth() {
        return this.sharedSettings.getFormattingSettings().getMaxLineWidth();
    }

    private int getTabSize() {
        return this.sharedSettings.getFormattingSettings().getTabSize();
    }

    private boolean isInsertSpaces() {
        return this.sharedSettings.getFormattingSettings().isInsertSpaces();
    }

    private boolean isTrimFinalNewlines() {
        return this.sharedSettings.getFormattingSettings().isTrimFinalNewlines();
    }

    private boolean isInsertFinalNewline() {
        return this.sharedSettings.getFormattingSettings().isInsertFinalNewline();
    }

    SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    String getLineDelimiter() {
        return this.lineDelimiter;
    }

    String getText() {
        return this.textDocument.getText();
    }
}

