/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.TextEdit;

public class DOMElementFormatter {
    private final XMLFormatterDocumentNew formatterDocument;
    private final DOMAttributeFormatter attributeFormatter;

    public DOMElementFormatter(XMLFormatterDocumentNew formatterDocument, DOMAttributeFormatter attributeFormatter) {
        this.formatterDocument = formatterDocument;
        this.attributeFormatter = attributeFormatter;
    }

    public void formatElement(DOMElement element, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements(element);
        int indentLevel = parentConstraints.getIndentLevel();
        int nb = this.formatStartTagElement(element, parentConstraints, emptyElements, edits);
        if (emptyElements == XMLFormattingOptions.EmptyElements.ignore) {
            XMLFormattingConstraints constraints = new XMLFormattingConstraints();
            constraints.copyConstraints(parentConstraints);
            if (element.isClosed()) {
                constraints.setIndentLevel(indentLevel + 1);
            }
            constraints.setFormatElementCategory(this.getFormatElementCategory(element, parentConstraints));
            constraints.setAvailableLineWidth(this.getMaxLineWidth() - nb);
            this.formatChildren(element, constraints, start, end, edits);
            if (element.hasEndTag()) {
                this.formatEndTagElement(element, parentConstraints, constraints, edits);
            }
        }
    }

    private int formatStartTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingOptions.EmptyElements emptyElements, List<TextEdit> edits) {
        int width = 0;
        int indentLevel = parentConstraints.getIndentLevel();
        FormatElementCategory formatElementCategory = parentConstraints.getFormatElementCategory();
        switch (formatElementCategory) {
            case PreserveSpace: {
                break;
            }
            case MixedContent: {
                break;
            }
            case IgnoreSpace: {
                boolean addLineSperator = element.getParentElement() == null && element.getPreviousSibling() == null;
                int startTagOffset = element.getStartTagOpenOffset();
                int nbSpaces = this.replaceLeftSpacesWithIndentation(indentLevel, startTagOffset, !addLineSperator, edits);
                width = nbSpaces + element.getStartTagCloseOffset() - startTagOffset;
            }
        }
        if (formatElementCategory != FormatElementCategory.PreserveSpace) {
            this.formatAttributes(element, parentConstraints, edits);
            boolean formatted = false;
            switch (emptyElements) {
                case expand: {
                    if (!element.isSelfClosed()) break;
                    StringBuilder tag = new StringBuilder();
                    tag.append(">");
                    tag.append("</");
                    tag.append(element.getTagName());
                    tag.append('>');
                    this.createTextEditIfNeeded(element.getEnd() - 3, element.getEnd(), tag.toString(), edits);
                    formatted = true;
                    break;
                }
                case collapse: {
                    if (element.isSelfClosed()) break;
                    StringBuilder tag = new StringBuilder();
                    if (this.isSpaceBeforeEmptyCloseTag()) {
                        tag.append(" ");
                    }
                    tag.append("/>");
                    this.createTextEditIfNeeded(element.getStartTagCloseOffset() - 1, element.getEnd(), tag.toString(), edits);
                    formatted = true;
                    break;
                }
            }
            if (!formatted) {
                if (element.isSelfClosed()) {
                    int offset = element.getEnd() - 2;
                    if (this.isSpaceBeforeEmptyCloseTag()) {
                        this.replaceLeftSpacesWithOneSpace(offset, edits);
                    } else {
                        this.removeLeftSpaces(offset, edits);
                    }
                } else if (element.isStartTagClosed()) {
                    this.formatElementStartTagCloseBracket(element, edits);
                }
            }
        }
        return width;
    }

    private int formatAttributes(DOMElement element, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        if (element.hasAttributes()) {
            List<DOMAttr> attributes = element.getAttributeNodes();
            int prevOffset = element.getOffsetAfterStartTag();
            boolean singleAttribute = attributes.size() == 1;
            for (DOMAttr attr : attributes) {
                this.attributeFormatter.formatAttribute(attr, prevOffset, singleAttribute, true, parentConstraints, edits);
                prevOffset = attr.getEnd();
            }
        }
        return 0;
    }

    private void formatElementStartTagCloseBracket(DOMElement element, List<TextEdit> edits) {
        int offset = element.getStartTagCloseOffset();
        String replace = "";
        if (this.isPreserveAttributeLineBreaks() && element.hasAttributes() && this.hasLineBreak(this.getLastAttribute(element).getEnd(), element.getStartTagCloseOffset())) {
            replace = this.formatterDocument.getLineDelimiter();
        }
        this.replaceLeftSpacesWith(offset, replace, edits);
    }

    private int formatEndTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingConstraints constraints, List<TextEdit> edits) {
        int endTagOffset;
        int indentLevel = parentConstraints.getIndentLevel();
        FormatElementCategory formatElementCategory = constraints.getFormatElementCategory();
        switch (formatElementCategory) {
            case PreserveSpace: {
                break;
            }
            case MixedContent: {
                break;
            }
            case IgnoreSpace: {
                endTagOffset = element.getEndTagOpenOffset();
                this.replaceLeftSpacesWithIndentation(indentLevel, endTagOffset, true, edits);
                break;
            }
        }
        if (element.isEndTagClosed()) {
            endTagOffset = element.getEndTagCloseOffset();
            this.removeLeftSpaces(endTagOffset, edits);
        }
        return 0;
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements(DOMElement element) {
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements();
        if (emptyElements != XMLFormattingOptions.EmptyElements.ignore && element.isClosed() && element.isEmpty()) {
            switch (emptyElements) {
                case expand: 
                case collapse: {
                    if (this.isPreserveEmptyContent() && element.hasChildNodes()) {
                        return XMLFormattingOptions.EmptyElements.ignore;
                    }
                    return emptyElements;
                }
            }
            return emptyElements;
        }
        return XMLFormattingOptions.EmptyElements.ignore;
    }

    private void replaceLeftSpacesWith(int offset, String replace, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(offset, replace, edits);
    }

    private void replaceLeftSpacesWithOneSpace(int offset, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithOneSpace(offset, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int offset, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, offset, addLineSeparator, edits);
    }

    private void removeLeftSpaces(int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(to, edits);
    }

    private void createTextEditIfNeeded(int from, int to, String expectedContent, List<TextEdit> edits) {
        this.formatterDocument.createTextEditIfNeeded(from, to, expectedContent, edits);
    }

    private boolean hasLineBreak(int end, int startTagCloseOffset) {
        return this.formatterDocument.hasLineBreak(end, startTagCloseOffset);
    }

    private DOMAttr getLastAttribute(DOMElement element) {
        if (!element.hasAttributes()) {
            return null;
        }
        List<DOMAttr> attributes = element.getAttributeNodes();
        return attributes.get(attributes.size() - 1);
    }

    private boolean isPreserveAttributeLineBreaks() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveAttributeLineBreaks();
    }

    private boolean isSpaceBeforeEmptyCloseTag() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSpaceBeforeEmptyCloseTag();
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getEmptyElements();
    }

    private boolean isPreserveEmptyContent() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveEmptyContent();
    }

    private void formatChildren(DOMElement element, XMLFormattingConstraints constraints, int start, int end, List<TextEdit> edits) {
        this.formatterDocument.formatChildren(element, constraints, start, end, edits);
    }

    private FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints) {
        return this.formatterDocument.getFormatElementCategory(element, parentConstraints);
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }
}

