/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.xsd.DataType;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XSDCompletionParticipant
extends CompletionParticipantAdapter {
    @Override
    public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        DOMNode node = request.getNode();
        DOMDocument document = node.getOwnerDocument();
        if (!DOMUtils.isXSD(document)) {
            return;
        }
        Range fullRange = request.getReplaceRange();
        DOMAttr originAttr = node.findAttrAt(request.getOffset());
        XSDUtils.BindingType bindingType = XSDUtils.getBindingType(originAttr);
        if (bindingType != XSDUtils.BindingType.NONE) {
            XSDUtils.searchXSTargetAttributes(originAttr, bindingType, false, true, (targetNamespacePrefix, targetAttr) -> {
                CompletionItem item = new CompletionItem();
                item.setDocumentation(new MarkupContent("markdown", DataType.getDocumentation(targetAttr)));
                String value = XSDCompletionParticipant.createComplexTypeValue(targetAttr, targetNamespacePrefix);
                String insertText = request.getInsertAttrValue(value);
                item.setLabel(value);
                item.setKind(CompletionItemKind.Value);
                item.setFilterText(insertText);
                item.setTextEdit(Either.forLeft((Object)new TextEdit(fullRange, insertText)));
                response.addCompletionItem(item);
            });
            if (bindingType.isSimple()) {
                String prefix = document.getSchemaPrefix();
                DataType.getDataTypes().forEach(dataType -> {
                    CompletionItem item = new CompletionItem();
                    item.setDocumentation(new MarkupContent("markdown", dataType.getDocumentation()));
                    String value = XSDCompletionParticipant.createDatatypeValue(dataType, prefix);
                    String insertText = request.getInsertAttrValue(value);
                    item.setLabel(value);
                    item.setKind(CompletionItemKind.Value);
                    item.setFilterText(insertText);
                    item.setTextEdit(Either.forLeft((Object)new TextEdit(fullRange, insertText)));
                    response.addCompletionItem(item);
                });
            }
        }
    }

    private static String createComplexTypeValue(DOMAttr targetAttr, String targetNamespacePrefix) {
        StringBuilder value = new StringBuilder();
        if (targetNamespacePrefix != null) {
            value.append(targetNamespacePrefix);
            value.append(":");
        }
        value.append(targetAttr.getValue());
        return value.toString();
    }

    private static String createDatatypeValue(DataType dataType, String prefix) {
        StringBuilder value = new StringBuilder();
        if (prefix != null) {
            value.append(prefix);
            value.append(":");
        }
        value.append(dataType.getName());
        return value.toString();
    }
}

