/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.ISymbolsProviderParticipant;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.junit.jupiter.api.Test;

public class SymbolsProviderParticipantTest {
    @Test
    public void insertCustomSymbols() {
        String xml = "<root />";
        SymbolsProviderParticipantTest.testDocumentSymbolsFor(xml, "insert.xml", XMLAssert.ds("Custom-Symbol", SymbolKind.Namespace, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null), XMLAssert.ds("root", SymbolKind.Field, XMLAssert.r(0, 0, 0, 8), XMLAssert.r(0, 0, 0, 8), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void replaceCustomSymbols() {
        String xml = "<root />";
        SymbolsProviderParticipantTest.testDocumentSymbolsFor(xml, "replace.xml", XMLAssert.ds("Custom-Symbol", SymbolKind.Namespace, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null));
    }

    @Test
    public void noCustomSymbols() {
        String xml = "<root />";
        SymbolsProviderParticipantTest.testDocumentSymbolsFor(xml, "test.xml", XMLAssert.ds("root", SymbolKind.Field, XMLAssert.r(0, 0, 0, 8), XMLAssert.r(0, 0, 0, 8), null, Arrays.asList(new DocumentSymbol[0])));
    }

    private static void testDocumentSymbolsFor(String xml, String fileURI, DocumentSymbol ... expected) {
        ExtendedSymbolLanguageService languageService = new ExtendedSymbolLanguageService();
        XMLAssert.testDocumentSymbolsFor(languageService, xml, fileURI, new XMLSymbolSettings(), null, expected);
    }

    private static class ExtendedSymbolLanguageService
    extends XMLLanguageService {
        public ExtendedSymbolLanguageService() {
            super.registerSymbolsProviderParticipant(new ISymbolsProviderParticipant(){

                public void findSymbolInformations(DOMDocument document, SymbolInformationResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                }

                public void findDocumentSymbols(DOMDocument document, DocumentSymbolsResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    symbols.add((Object)new DocumentSymbol("Custom-Symbol", SymbolKind.Namespace, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1)));
                }

                public ISymbolsProviderParticipant.SymbolStrategy applyFor(DOMDocument document) {
                    String uri = document.getDocumentURI();
                    if ("replace.xml".equals(uri)) {
                        return ISymbolsProviderParticipant.SymbolStrategy.REPLACE;
                    }
                    if ("insert.xml".equals(uri)) {
                        return ISymbolsProviderParticipant.SymbolStrategy.INSERT;
                    }
                    return ISymbolsProviderParticipant.SymbolStrategy.UNADAPTABLE;
                }
            });
        }
    }
}

