/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;
import org.eclipse.lsp4j.Position;

public class XMLDeclarationSnippetContext
implements IXMLSnippetContext {
    public static IXMLSnippetContext DEFAULT_CONTEXT = new XMLDeclarationSnippetContext();

    @Override
    public boolean isMatch(ICompletionRequest request, Map<String, String> model) {
        DOMDocument document = request.getXMLDocument();
        DOMNode node = request.getNode();
        int offset = request.getOffset();
        if ((node.isComment() || node.isDoctype()) && offset < node.getEnd()) {
            return false;
        }
        if (document.isBeforeProlog(offset) || XMLDeclarationSnippetContext.inProlog(document, offset)) {
            return false;
        }
        Position start = request.getReplaceRange().getStart();
        if (start.getLine() > 0) {
            return false;
        }
        DOMElement documentElement = document.getDocumentElement();
        if (documentElement != null && documentElement.hasTagName()) {
            return offset <= documentElement.getStart();
        }
        return true;
    }

    private static boolean inProlog(DOMDocument document, int offset) {
        DOMNode node = document.getFirstChild();
        if (node == null) {
            return false;
        }
        if (node.isProlog()) {
            return offset > node.getStart() + "<?xml".length();
        }
        return false;
    }
}

