/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReference;

public class XMLReferences {
    private final Predicate<DOMDocument> documentPredicate;
    private final List<XMLReference> references;

    XMLReferences(Predicate<DOMDocument> documentPredicate) {
        this.documentPredicate = documentPredicate;
        this.references = new ArrayList<XMLReference>();
    }

    public XMLReference from(String from) {
        XMLReference reference = new XMLReference(from);
        this.references.add(reference);
        return reference;
    }

    boolean canApply(DOMDocument document) {
        return this.documentPredicate.test(document);
    }

    void collectNodes(DOMNode node, Consumer<DOMNode> collector) throws XPathExpressionException {
        for (XMLReference reference : this.references) {
            if (!reference.match(node)) continue;
            reference.collect(node, collector);
        }
    }
}

