/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Collection;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class AttributeCompletionItem
extends CompletionItem {
    public AttributeCompletionItem(String attrName, boolean canSupportSnippets, Range fullRange, boolean generateValue, String defaultValue, Collection<String> enumerationValues, SharedSettings sharedSettings) {
        super.setLabel(attrName);
        super.setKind(CompletionItemKind.Unit);
        super.setFilterText(attrName);
        StringBuilder attributeContent = new StringBuilder(attrName);
        if (generateValue) {
            String attributeValue = XMLGenerator.generateAttributeValue(defaultValue, enumerationValues, canSupportSnippets, 1, true, sharedSettings);
            attributeContent.append(attributeValue);
        }
        super.setTextEdit(Either.forLeft((Object)new TextEdit(fullRange, attributeContent.toString())));
        super.setInsertTextFormat(canSupportSnippets ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
    }
}

