/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.DTDNotationDecl;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.LimitList;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.extensions.ISymbolsProviderParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.DocumentType;
import org.w3c.dom.ProcessingInstruction;

class XMLSymbolsProvider {
    private static final Logger LOGGER = Logger.getLogger(XMLSymbolsProvider.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLSymbolsProvider(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public SymbolInformationResult findSymbolInformations(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings, CancelChecker cancelChecker) {
        AtomicLong limit = symbolSettings.getMaxItemsComputed() >= 0 ? new AtomicLong(symbolSettings.getMaxItemsComputed()) : null;
        SymbolInformationResult symbols = new SymbolInformationResult(limit);
        XMLSymbolFilter filter = symbolSettings.getFilterFor(xmlDocument.getDocumentURI());
        try {
            if (this.processSymbolsParticipants(xmlDocument, symbols, null, filter, cancelChecker)) {
                return symbols;
            }
            boolean isDTD = xmlDocument.isDTD();
            boolean hasFilterForAttr = filter.hasFilterFor(IXPathNodeMatcher.MatcherType.ATTRIBUTE);
            for (DOMNode node : xmlDocument.getRoots()) {
                try {
                    this.findSymbolInformations(node, "", symbols, node.isDoctype() && isDTD, filter, hasFilterForAttr, cancelChecker);
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "XMLSymbolsProvider#findSymbolInformations was given a BadLocation by a 'node' variable", e);
                }
            }
        }
        catch (LimitList.ResultLimitExceededException e) {
            symbols.setResultLimitExceeded(true);
        }
        return symbols;
    }

    private void findSymbolInformations(DOMNode node, String container, List<SymbolInformation> symbols, boolean ignoreNode, XMLSymbolFilter filter, boolean hasFilterForAttr, CancelChecker cancelChecker) throws BadLocationException {
        if (!this.isNodeSymbol(node, filter)) {
            return;
        }
        String name = "";
        if (!ignoreNode) {
            name = XMLSymbolsProvider.nodeToName(node, filter);
            DOMDocument xmlDocument = node.getOwnerDocument();
            Range range = XMLSymbolsProvider.getSymbolRange(node);
            Location location = new Location(xmlDocument.getDocumentURI(), range);
            SymbolInformation symbol = new SymbolInformation(name, XMLSymbolsProvider.getSymbolKind(node), location, container);
            symbols.add(symbol);
        }
        String containerName = name;
        if (node.isElement()) {
            boolean collectAttributes;
            boolean bl = collectAttributes = hasFilterForAttr && node.hasAttributes();
            if (collectAttributes) {
                for (DOMAttr attr : node.getAttributeNodes()) {
                    this.findSymbolInformations(attr, containerName, symbols, false, filter, hasFilterForAttr, cancelChecker);
                }
            }
        }
        node.getChildren().forEach(child -> {
            try {
                this.findSymbolInformations((DOMNode)child, containerName, symbols, false, filter, hasFilterForAttr, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider was given a BadLocation by the provided 'node' variable", e);
            }
        });
    }

    public DocumentSymbolsResult findDocumentSymbols(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings, CancelChecker cancelChecker) {
        AtomicLong limit = symbolSettings.getMaxItemsComputed() >= 0 ? new AtomicLong(symbolSettings.getMaxItemsComputed()) : null;
        DocumentSymbolsResult symbols = new DocumentSymbolsResult(limit);
        XMLSymbolFilter filter = symbolSettings.getFilterFor(xmlDocument.getDocumentURI());
        try {
            if (this.processSymbolsParticipants(xmlDocument, null, symbols, filter, cancelChecker)) {
                return symbols;
            }
            boolean isDTD = xmlDocument.isDTD();
            boolean hasFilterForAttr = filter.hasFilterFor(IXPathNodeMatcher.MatcherType.ATTRIBUTE);
            ArrayList nodesToIgnore = new ArrayList();
            xmlDocument.getRoots().forEach(node -> {
                try {
                    if (node.isDoctype() && isDTD) {
                        nodesToIgnore.add(node);
                    }
                    this.findDocumentSymbols((DOMNode)node, symbols, nodesToIgnore, filter, hasFilterForAttr, cancelChecker);
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "XMLSymbolsProvider#findDocumentSymbols was given a BadLocation by a 'node' variable", e);
                }
            });
        }
        catch (LimitList.ResultLimitExceededException e) {
            symbols.setResultLimitExceeded(true);
        }
        return symbols;
    }

    private void findDocumentSymbols(DOMNode node, DocumentSymbolsResult symbols, List<DOMNode> nodesToIgnore, XMLSymbolFilter filter, boolean hasFilterForAttr, CancelChecker cancelChecker) throws BadLocationException {
        if (!this.isNodeSymbol(node, filter)) {
            return;
        }
        cancelChecker.checkCanceled();
        boolean hasChildNodes = node.hasChildNodes();
        DocumentSymbolsResult childrenSymbols = symbols;
        if (nodesToIgnore == null || !nodesToIgnore.contains(node)) {
            Range selectionRange;
            String name;
            if (nodesToIgnore != null && node.isDTDAttListDecl()) {
                DTDAttlistDecl decl = (DTDAttlistDecl)node;
                name = decl.getElementName();
                selectionRange = XMLSymbolsProvider.getSymbolRange(node, true);
            } else {
                name = XMLSymbolsProvider.nodeToName(node, filter);
                selectionRange = XMLSymbolsProvider.getSymbolRange(node);
            }
            boolean collectAttributes = hasFilterForAttr && node.hasAttributes();
            Range range = selectionRange;
            childrenSymbols = hasChildNodes || node.isDTDElementDecl() || node.isDTDAttListDecl() || collectAttributes ? symbols.createList() : DocumentSymbolsResult.EMPTY_LIMITLESS_LIST;
            DocumentSymbol symbol = new DocumentSymbol(name, XMLSymbolsProvider.getSymbolKind(node), range, selectionRange, null, (List)childrenSymbols);
            symbols.add(symbol);
            if (node.isElement()) {
                if (collectAttributes) {
                    for (DOMAttr attr : node.getAttributeNodes()) {
                        this.findDocumentSymbols(attr, childrenSymbols, null, filter, hasFilterForAttr, cancelChecker);
                    }
                }
            } else if (node.isDTDElementDecl() || nodesToIgnore != null && node.isDTDAttListDecl()) {
                Collection<DOMNode> attlistDecls;
                if (node.isDTDElementDecl()) {
                    DTDElementDecl elementDecl = (DTDElementDecl)node;
                    String elementName = elementDecl.getName();
                    attlistDecls = node.getOwnerDocument().findDTDAttrList(elementName);
                } else {
                    attlistDecls = new ArrayList<DOMNode>();
                    attlistDecls.add(node);
                }
                for (DOMNode attrDecl : attlistDecls) {
                    DTDAttlistDecl decl;
                    List<DTDAttlistDecl> otherAttributeDecls;
                    this.findDocumentSymbols(attrDecl, childrenSymbols, null, filter, hasFilterForAttr, cancelChecker);
                    if (attrDecl instanceof DTDAttlistDecl && (otherAttributeDecls = (decl = (DTDAttlistDecl)attrDecl).getInternalChildren()) != null) {
                        for (DTDAttlistDecl internalDecl : otherAttributeDecls) {
                            this.findDocumentSymbols(internalDecl, childrenSymbols, null, filter, hasFilterForAttr, cancelChecker);
                        }
                    }
                    nodesToIgnore.add(attrDecl);
                }
            }
        }
        if (!hasChildNodes) {
            return;
        }
        DocumentSymbolsResult childrenOfChild = childrenSymbols;
        node.getChildren().forEach(child -> {
            try {
                this.findDocumentSymbols((DOMNode)child, childrenOfChild, nodesToIgnore, filter, hasFilterForAttr, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider was given a BadLocation by the provided 'node' variable", e);
            }
        });
    }

    private boolean isNodeSymbol(DOMNode node, XMLSymbolFilter filter) {
        return !node.isText() && filter.isNodeSymbol(node);
    }

    private static Range getSymbolRange(DOMNode node) throws BadLocationException {
        return XMLSymbolsProvider.getSymbolRange(node, false);
    }

    private static Range getSymbolRange(DOMNode node, boolean useAttlistElementName) throws BadLocationException {
        DOMDocument xmlDocument = node.getOwnerDocument();
        if (node.isDTDAttListDecl() && !useAttlistElementName) {
            DTDAttlistDecl attlistDecl = (DTDAttlistDecl)node;
            DTDDeclParameter attributeNameDecl = attlistDecl.attributeName;
            if (attributeNameDecl != null) {
                Position start = xmlDocument.positionAt(attributeNameDecl.getStart());
                Position end = xmlDocument.positionAt(attributeNameDecl.getEnd());
                return new Range(start, end);
            }
        }
        Position start = xmlDocument.positionAt(node.getStart());
        Position end = xmlDocument.positionAt(node.getEnd());
        return new Range(start, end);
    }

    private static SymbolKind getSymbolKind(DOMNode node) {
        if (node.isProcessingInstruction() || node.isProlog()) {
            return SymbolKind.Property;
        }
        if (node.isDoctype()) {
            return SymbolKind.Struct;
        }
        if (node.isDTDElementDecl()) {
            return SymbolKind.Property;
        }
        if (node.isDTDEntityDecl()) {
            return SymbolKind.Namespace;
        }
        if (node.isDTDAttListDecl()) {
            return SymbolKind.Key;
        }
        if (node.isDTDNotationDecl()) {
            return SymbolKind.Variable;
        }
        if (node.isAttribute()) {
            return SymbolKind.Constant;
        }
        return SymbolKind.Field;
    }

    private static String nodeToName(DOMNode node, XMLSymbolFilter filter) {
        String name = XMLSymbolsProvider.nodeToNameOrNull(node, filter);
        return name != null ? name : "?";
    }

    private static String nodeToNameOrNull(DOMNode node, XMLSymbolFilter filter) {
        if (node.isElement()) {
            DOMElement element = (DOMElement)node;
            if (element.hasTagName()) {
                DOMNode firstChild = node.getFirstChild();
                if (firstChild != null && firstChild.isText() && filter.isNodeSymbol(firstChild)) {
                    return element.getTagName() + ": " + firstChild.getNodeValue();
                }
                return element.getTagName();
            }
        } else if (node.isAttribute()) {
            DOMAttr attr = (DOMAttr)node;
            if (attr.getName() != null) {
                return "@" + attr.getName() + ": " + attr.getValue();
            }
        } else {
            if (node.isProcessingInstruction() || node.isProlog()) {
                return ((ProcessingInstruction)((Object)node)).getTarget();
            }
            if (node.isDoctype()) {
                return "DOCTYPE:" + ((DocumentType)((Object)node)).getName();
            }
            if (node.isDTDElementDecl()) {
                return ((DTDElementDecl)node).getName();
            }
            if (node.isDTDAttListDecl()) {
                DTDAttlistDecl attr = (DTDAttlistDecl)node;
                return attr.getAttributeName();
            }
            if (node.isDTDEntityDecl()) {
                return node.getNodeName();
            }
            if (node.isDTDNotationDecl()) {
                DTDNotationDecl notation = (DTDNotationDecl)node;
                return notation.getName();
            }
        }
        return null;
    }

    private boolean processSymbolsParticipants(DOMDocument xmlDocument, SymbolInformationResult symbolInformations, DocumentSymbolsResult documentSymbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
        SymbolsProviderParticipantResult resultParticipant = this.getSymbolsProviderParticipant(xmlDocument);
        Collection<ISymbolsProviderParticipant> replaceParticipants = resultParticipant.getReplaceParticipants();
        if (!replaceParticipants.isEmpty()) {
            if (replaceParticipants.size() > 1) {
                LOGGER.log(Level.WARNING, "There are '" + replaceParticipants.size() + "' replace participants");
            }
            for (ISymbolsProviderParticipant replaceParticipant : replaceParticipants) {
                if (symbolInformations != null) {
                    replaceParticipant.findSymbolInformations(xmlDocument, symbolInformations, filter, cancelChecker);
                }
                if (documentSymbols == null) continue;
                replaceParticipant.findDocumentSymbols(xmlDocument, documentSymbols, filter, cancelChecker);
            }
            return true;
        }
        Collection<ISymbolsProviderParticipant> insertParticipants = resultParticipant.getInsertParticipants();
        if (!insertParticipants.isEmpty()) {
            for (ISymbolsProviderParticipant insertParticipant : insertParticipants) {
                if (symbolInformations != null) {
                    insertParticipant.findSymbolInformations(xmlDocument, symbolInformations, filter, cancelChecker);
                }
                if (documentSymbols == null) continue;
                insertParticipant.findDocumentSymbols(xmlDocument, documentSymbols, filter, cancelChecker);
            }
        }
        return false;
    }

    private SymbolsProviderParticipantResult getSymbolsProviderParticipant(DOMDocument xmlDocument) {
        Collection<ISymbolsProviderParticipant> all = this.extensionsRegistry.getSymbolsProviderParticipants();
        ArrayList<ISymbolsProviderParticipant> insertParticipant = null;
        ArrayList<ISymbolsProviderParticipant> replaceParticipant = null;
        for (ISymbolsProviderParticipant participant : all) {
            ISymbolsProviderParticipant.SymbolStrategy strategy = participant.applyFor(xmlDocument);
            switch (strategy) {
                case INSERT: {
                    if (insertParticipant == null) {
                        insertParticipant = new ArrayList<ISymbolsProviderParticipant>();
                    }
                    insertParticipant.add(participant);
                    break;
                }
                case REPLACE: {
                    if (replaceParticipant == null) {
                        replaceParticipant = new ArrayList<ISymbolsProviderParticipant>();
                    }
                    replaceParticipant.add(participant);
                }
            }
        }
        return new SymbolsProviderParticipantResult(replaceParticipant, insertParticipant);
    }

    private static class SymbolsProviderParticipantResult {
        private final Collection<ISymbolsProviderParticipant> replaceParticipants;
        private final Collection<ISymbolsProviderParticipant> insertParticipants;

        public SymbolsProviderParticipantResult(Collection<ISymbolsProviderParticipant> replaceParticipants, Collection<ISymbolsProviderParticipant> insertParticipants) {
            this.replaceParticipants = replaceParticipants != null ? replaceParticipants : Collections.emptyList();
            this.insertParticipants = insertParticipants != null ? insertParticipants : Collections.emptyList();
        }

        public Collection<ISymbolsProviderParticipant> getReplaceParticipants() {
            return this.replaceParticipants;
        }

        public Collection<ISymbolsProviderParticipant> getInsertParticipants() {
            return this.insertParticipants;
        }
    }
}

