/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.util.MessageFormatter;
import org.eclipse.lemminx.dom.parser.Constants;
import org.eclipse.lemminx.dom.parser.MultiLineStream;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.utils.StringUtils;

public class LSPMessageFormatter
implements MessageFormatter {
    public static final String SCHEMA_DOMAIN = "http://www.w3.org/TR/xml-schema-1";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;
    private ResourceBundle newResourceBundle = null;

    public String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != this.fLocale) {
            this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLSchemaMessages", locale);
            this.newResourceBundle = ResourceBundle.getBundle("XMLSchemaMessagesReformatted", locale);
            this.fLocale = locale;
        }
        boolean usedNewResourceBundle = false;
        String msg = null;
        if (this.newResourceBundle.containsKey(key)) {
            msg = this.newResourceBundle.getString(key);
            usedNewResourceBundle = true;
        } else {
            msg = this.fResourceBundle.getString(key);
        }
        if (arguments != null) {
            try {
                if (usedNewResourceBundle) {
                    arguments = LSPMessageFormatter.reformatSchemaArguments(XMLSchemaErrorCode.get(key), arguments);
                }
                msg = MessageFormat.format(msg, arguments);
            }
            catch (Exception e) {
                msg = this.fResourceBundle.getString("FormatFailed");
                msg = msg + " " + this.fResourceBundle.getString(key);
            }
        }
        if (msg == null) {
            msg = this.fResourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(msg, "XMLSchemaMessages", key);
        }
        return msg;
    }

    public static Object[] reformatSchemaArguments(XMLSchemaErrorCode code, Object[] arguments) {
        switch (code) {
            case cvc_complex_type_2_4_a: {
                return LSPMessageFormatter.cvc_2_4_a_solution(arguments);
            }
            case cvc_complex_type_2_4_b: {
                return LSPMessageFormatter.cvc_2_4_b_solution(arguments);
            }
            case cvc_enumeration_valid: {
                return LSPMessageFormatter.enumeration_valid_solution(arguments);
            }
            case cvc_complex_type_4: {
                arguments[1] = "- " + arguments[1];
                arguments[0] = "- " + arguments[0];
            }
        }
        return arguments;
    }

    private static String reformatElementNames(String names) {
        StringBuilder result = new StringBuilder();
        MultiLineStream stream = new MultiLineStream(names, 0);
        while (!stream.eos()) {
            boolean hasNamespace;
            stream.advance(1);
            boolean bl = hasNamespace = stream.peekChar() == Constants._DQO;
            if (hasNamespace) {
                stream.advance(1);
                stream.advanceUntilAnyOfChars(Constants._DQO, Constants._SQO, Constants._SIQ);
                stream.advance(2);
            }
            result.append(" - ");
            while (stream.peekChar() != Constants._CCB && stream.peekChar() != Constants._CMA) {
                result.append(Character.toString((char)stream.peekChar()));
                stream.advance(1);
            }
            result.append("\n");
            stream.advance(1);
        }
        return result.toString();
    }

    private static String reformatArrayElementNames(String names) {
        StringBuilder sb = new StringBuilder();
        MultiLineStream stream = new MultiLineStream(names, 0);
        while (!stream.eos()) {
            stream.advance(1);
            sb.append(" - ");
            while (stream.peekChar() != Constants._CSB && stream.peekChar() != Constants._CMA) {
                sb.append(Character.toString((char)stream.peekChar()));
                stream.advance(1);
            }
            sb.append("\n");
            stream.advance(1);
        }
        return sb.toString();
    }

    private static Matcher getNamespaceMatcher(String name) {
        Pattern namespacePattern = Pattern.compile("^\\{\"(.*)\":(.*)(\\}|,)");
        return namespacePattern.matcher(name);
    }

    private static Object[] cvc_2_4_a_solution(Object[] arguments) {
        Matcher m = LSPMessageFormatter.getNamespaceMatcher(StringUtils.getString(arguments[0]));
        String schema = null;
        String name = null;
        String validNames = null;
        if (m.matches()) {
            name = m.group(2);
            schema = "{" + m.group(1) + "}";
            validNames = LSPMessageFormatter.reformatElementNames(StringUtils.getString(arguments[1]));
        } else {
            name = StringUtils.getString(arguments[0]);
            schema = "{the schema}";
            validNames = LSPMessageFormatter.reformatElementNames(StringUtils.getString(arguments[1]));
        }
        name = "- " + name;
        return new Object[]{name, validNames, schema};
    }

    private static Object[] cvc_2_4_b_solution(Object[] arguments) {
        Matcher m = LSPMessageFormatter.getNamespaceMatcher(StringUtils.getString(arguments[1]));
        String element = null;
        String missingChildElements = null;
        String schema = null;
        if (m.matches()) {
            missingChildElements = LSPMessageFormatter.reformatElementNames(StringUtils.getString(arguments[1]));
            schema = "{" + m.group(1) + "}";
        } else {
            missingChildElements = LSPMessageFormatter.reformatElementNames(StringUtils.getString(arguments[1]));
            schema = "{the schema}";
        }
        element = "- " + StringUtils.getString(arguments[0]);
        return new Object[]{element, missingChildElements, schema};
    }

    public static Object[] enumeration_valid_solution(Object[] arguments) {
        return new Object[]{StringUtils.getString(arguments[0]), LSPMessageFormatter.reformatArrayElementNames(StringUtils.getString(arguments[1]))};
    }
}

