/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.settings;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lemminx.settings.PathPatternMatcher;
import org.eclipse.lemminx.utils.DOMUtils;

public class XMLFileAssociation
extends PathPatternMatcher {
    private transient Map<String, String> externalSchemaLocation;
    private String systemId;

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.externalSchemaLocation = null;
    }

    public Map<String, String> getExternalSchemaLocation() {
        if (this.externalSchemaLocation == null) {
            this.externalSchemaLocation = new HashMap<String, String>();
            if (DOMUtils.isXSD(this.systemId)) {
                this.externalSchemaLocation.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.systemId);
            } else {
                this.externalSchemaLocation.put("http://apache.org/xml/properties/dtd/external-doctype", this.systemId);
            }
        }
        return this.externalSchemaLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getPattern() == null ? 0 : this.getPattern().hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLFileAssociation other = (XMLFileAssociation)obj;
        String thisPattern = this.getPattern();
        String otherPattern = other.getPattern();
        if (thisPattern == null ? otherPattern != null : !thisPattern.equals(otherPattern)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }
}

