/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.services.extensions.commands.IXMLCommandService;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.WorkspaceService;

public class XMLWorkspaceService
implements WorkspaceService,
IXMLCommandService {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    private final XMLLanguageServer xmlLanguageServer;
    private final Map<String, IXMLCommandService.IDelegateCommandHandler> commands;
    private final Map<String, String> commandRegistrations;

    public XMLWorkspaceService(XMLLanguageServer xmlLanguageServer) {
        this.xmlLanguageServer = xmlLanguageServer;
        this.commands = new HashMap<String, IXMLCommandService.IDelegateCommandHandler>();
        this.commandRegistrations = new HashMap<String, String>();
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            IXMLCommandService.IDelegateCommandHandler handler = this.commands.get(params.getCommand());
            if (handler == null) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, "No command handler for the command: " + params.getCommand(), null));
            }
            return CompletableFutures.computeAsync(cancelChecker -> {
                try {
                    return handler.executeCommand(params, (CancelChecker)cancelChecker);
                }
                catch (Exception e) {
                    if (e instanceof ResponseErrorException) {
                        throw (ResponseErrorException)e;
                    }
                    if (e instanceof CancellationException) {
                        throw (CancellationException)e;
                    }
                    throw new ResponseErrorException(new ResponseError(ResponseErrorCode.UnknownErrorCode, e.getMessage(), (Object)e));
                }
            });
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.xmlLanguageServer.updateSettings(params.getSettings());
        this.xmlLanguageServer.getCapabilityManager().syncDynamicCapabilitiesWithPreferences();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        XMLTextDocumentService xmlTextDocumentService = (XMLTextDocumentService)this.xmlLanguageServer.getTextDocumentService();
        List changes = params.getChanges();
        for (FileEvent change : changes) {
            if (xmlTextDocumentService.documentIsOpen(change.getUri())) continue;
            xmlTextDocumentService.doSave(change.getUri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCommand(String commandId, IXMLCommandService.IDelegateCommandHandler handler) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            if (this.commands.containsKey(commandId)) {
                throw new IllegalArgumentException("Command with id '" + commandId + "' is already registered");
            }
            String registrationId = UUID.randomUUID().toString();
            this.xmlLanguageServer.getCapabilityManager().registerCapability(registrationId, WORKSPACE_EXECUTE_COMMAND, ImmutableMap.of((Object)"commands", (Object)ImmutableList.of((Object)commandId)));
            this.commandRegistrations.put(commandId, registrationId);
            this.commands.put(commandId, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCommand(String commandId) {
        Map<String, IXMLCommandService.IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            this.commands.remove(commandId);
            String registrationId = this.commandRegistrations.remove(commandId);
            if (registrationId != null) {
                this.xmlLanguageServer.getCapabilityManager().unregisterCapability(registrationId, WORKSPACE_EXECUTE_COMMAND);
            }
        }
    }

    @Override
    public CompletableFuture<Object> executeClientCommand(ExecuteCommandParams command) {
        return this.xmlLanguageServer.getLanguageClient().executeClientCommand(command);
    }
}

