/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelValidator;

public class XMLModelDTDValidator
extends XMLDTDValidator
implements XMLModelValidator {
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private String href;
    private boolean rootElement = true;
    private XMLLocator locator;
    private XMLEntityManager entityManager;

    public XMLModelDTDValidator() {
        this.fDTDValidation = true;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void setLocator(XMLLocator locator) {
        this.locator = locator;
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.rootElement) {
            QName fRootElement = this.getRootElement();
            String rootElementName = element.localpart;
            this.fSeenDoctypeDecl = true;
            fRootElement.setValues(null, rootElementName, rootElementName, null);
            String eid = null;
            try {
                eid = XMLEntityManager.expandSystemId((String)this.href, (String)this.locator.getExpandedSystemId(), (boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            XMLDTDDescription grammarDesc = new XMLDTDDescription(null, this.href, this.locator.getExpandedSystemId(), eid, rootElementName);
            this.fDTDGrammar = this.fGrammarBucket.getGrammar((XMLGrammarDescription)grammarDesc);
            if (this.fDTDGrammar == null && this.fGrammarPool != null && this.href != null) {
                this.fDTDGrammar = (DTDGrammar)this.fGrammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc);
            }
            if (this.fDTDGrammar == null) {
                XMLDTDLoader loader = new XMLDTDLoader(this.fSymbolTable, this.fGrammarPool);
                loader.setEntityResolver((XMLEntityResolver)this.entityManager);
                try {
                    this.fDTDGrammar = (DTDGrammar)loader.loadGrammar(new XMLInputSource(null, eid, null));
                }
                catch (IOException iOException) {}
            } else {
                this.fValidationManager.setCachedDTD(true);
            }
            this.rootElement = false;
        }
        super.startElement(element, attributes, augs);
    }

    private QName getRootElement() {
        try {
            Field f = XMLDTDValidator.class.getDeclaredField("fRootElement");
            f.setAccessible(true);
            QName fRootElement = (QName)f.get(this);
            return fRootElement;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.entityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        super.reset(componentManager);
    }
}

