/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.pushstream.AbstractBufferBuilder;
import org.osgi.util.pushstream.AbstractPushStreamImpl;
import org.osgi.util.pushstream.BufferBuilder;
import org.osgi.util.pushstream.BufferedPushStreamImpl;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamBuilder;
import org.osgi.util.pushstream.PushStreamBuilderImpl;
import org.osgi.util.pushstream.PushbackPolicy;
import org.osgi.util.pushstream.PushbackPolicyOption;
import org.osgi.util.pushstream.QueuePolicy;
import org.osgi.util.pushstream.QueuePolicyOption;
import org.osgi.util.pushstream.SimplePushEventSource;
import org.osgi.util.pushstream.SimplePushEventSourceImpl;
import org.osgi.util.pushstream.UnbufferedPushStreamImpl;

public final class PushStreamProvider {
    private final Lock lock = new ReentrantLock(true);
    private int schedulerReferences;
    private ScheduledExecutorService sharedScheduler;

    private ScheduledExecutorService acquireScheduler() {
        this.lock.lockInterruptibly();
        try {
            ++this.schedulerReferences;
            if (this.schedulerReferences == 1) {
                this.sharedScheduler = Executors.newSingleThreadScheduledExecutor();
            }
            ScheduledExecutorService scheduledExecutorService = this.sharedScheduler;
            this.lock.unlock();
            return scheduledExecutorService;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unable to acquire the Scheduler", e);
            }
        }
    }

    private void releaseScheduler() {
        try {
            this.lock.lockInterruptibly();
            try {
                --this.schedulerReferences;
                if (this.schedulerReferences == 0) {
                    this.sharedScheduler.shutdown();
                    this.sharedScheduler = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public <T> PushStream<T> createStream(PushEventSource<T> eventSource) {
        return this.createStream(eventSource, 1, null, null, new ArrayBlockingQueue(32), QueuePolicyOption.FAIL.getPolicy(), PushbackPolicyOption.LINEAR.getPolicy(1000L));
    }

    public <T, U extends BlockingQueue<PushEvent<? extends T>>> PushStreamBuilder<T, U> buildStream(PushEventSource<T> eventSource) {
        return new PushStreamBuilderImpl(this, null, null, eventSource);
    }

    <T, U extends BlockingQueue<PushEvent<? extends T>>> PushStream<T> createStream(PushEventSource<T> eventSource, int parallelism, Executor executor, ScheduledExecutorService scheduler, U queue, QueuePolicy<T, U> queuePolicy, PushbackPolicy<T, U> pushbackPolicy) {
        boolean releaseSchedulerOnClose;
        ScheduledExecutorService timerToUse;
        boolean closeExecutorOnClose;
        Executor workerToUse;
        if (eventSource == null) {
            throw new NullPointerException("There is no source of events");
        }
        if (parallelism < 0) {
            throw new IllegalArgumentException("The supplied parallelism cannot be less than zero. It was " + parallelism);
        }
        if (parallelism == 0) {
            parallelism = 1;
        }
        if (executor == null) {
            workerToUse = Executors.newFixedThreadPool(parallelism);
            closeExecutorOnClose = true;
        } else {
            workerToUse = Objects.requireNonNull(executor);
            closeExecutorOnClose = false;
        }
        if (scheduler == null) {
            timerToUse = this.acquireScheduler();
            releaseSchedulerOnClose = true;
        } else {
            timerToUse = Objects.requireNonNull(scheduler);
            releaseSchedulerOnClose = false;
        }
        if (queue == null) {
            queue = new ArrayBlockingQueue(32);
        }
        if (queuePolicy == null) {
            queuePolicy = QueuePolicyOption.FAIL.getPolicy();
        }
        if (pushbackPolicy == null) {
            pushbackPolicy = PushbackPolicyOption.LINEAR.getPolicy(1000L);
        }
        BufferedPushStreamImpl<T, U> stream = new BufferedPushStreamImpl<T, U>(this, new PromiseFactory(workerToUse, timerToUse), queue, parallelism, queuePolicy, pushbackPolicy, aec -> {
            try {
                return eventSource.open((PushEventConsumer)aec);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to connect to event source", e);
            }
        });
        return this.cleanupThreads(closeExecutorOnClose, workerToUse, releaseSchedulerOnClose, stream);
    }

    private <T> PushStream<T> cleanupThreads(boolean closeExecutorOnClose, Executor workerToUse, boolean releaseSchedulerOnClose, PushStream<T> stream) {
        if (closeExecutorOnClose || releaseSchedulerOnClose) {
            stream = stream.onClose(() -> {
                if (closeExecutorOnClose) {
                    ((ExecutorService)workerToUse).shutdown();
                }
                if (releaseSchedulerOnClose) {
                    this.releaseScheduler();
                }
            }).map(x -> x);
        }
        return stream;
    }

    <T> PushStream<T> createUnbufferedStream(PushEventSource<T> eventSource, Executor executor, ScheduledExecutorService scheduler) {
        boolean releaseSchedulerOnClose;
        ScheduledExecutorService timerToUse;
        boolean closeExecutorOnClose;
        Executor workerToUse;
        if (executor == null) {
            workerToUse = Executors.newFixedThreadPool(2);
            closeExecutorOnClose = true;
        } else {
            workerToUse = Objects.requireNonNull(executor);
            closeExecutorOnClose = false;
        }
        if (scheduler == null) {
            timerToUse = this.acquireScheduler();
            releaseSchedulerOnClose = true;
        } else {
            timerToUse = Objects.requireNonNull(scheduler);
            releaseSchedulerOnClose = false;
        }
        UnbufferedPushStreamImpl stream = new UnbufferedPushStreamImpl(this, new PromiseFactory(workerToUse, timerToUse), aec -> {
            try {
                return eventSource.open((PushEventConsumer)aec);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to connect to event source", e);
            }
        });
        return this.cleanupThreads(closeExecutorOnClose, workerToUse, releaseSchedulerOnClose, stream);
    }

    public <T> PushEventSource<T> createEventSourceFromStream(PushStream<T> stream) {
        return this.buildEventSourceFromStream(stream).build();
    }

    public <T, U extends BlockingQueue<PushEvent<? extends T>>> BufferBuilder<PushEventSource<T>, T, U> buildEventSourceFromStream(PushStream<T> stream) {
        final PushStreamBuilder builder = stream.buildBuffer();
        return new BufferBuilder<PushEventSource<T>, T, U>(){

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withBuffer(U queue) {
                builder.withBuffer(queue);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withQueuePolicy(QueuePolicy<T, U> queuePolicy) {
                builder.withQueuePolicy(queuePolicy);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withQueuePolicy(QueuePolicyOption queuePolicyOption) {
                builder.withQueuePolicy(queuePolicyOption);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withPushbackPolicy(PushbackPolicy<T, U> pushbackPolicy) {
                builder.withPushbackPolicy(pushbackPolicy);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withPushbackPolicy(PushbackPolicyOption pushbackPolicyOption, long time) {
                builder.withPushbackPolicy(pushbackPolicyOption, time);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withParallelism(int parallelism) {
                builder.withParallelism(parallelism);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withExecutor(Executor executor) {
                builder.withExecutor(executor);
                return this;
            }

            @Override
            public BufferBuilder<PushEventSource<T>, T, U> withScheduler(ScheduledExecutorService scheduler) {
                builder.withScheduler(scheduler);
                return this;
            }

            @Override
            public PushEventSource<T> build() {
                AtomicBoolean connect = new AtomicBoolean();
                AtomicReference terminalEvent = new AtomicReference();
                CopyOnWriteArrayList consumers = new CopyOnWriteArrayList();
                return consumer -> {
                    consumers.add(consumer);
                    PushEvent terminal = (PushEvent)terminalEvent.get();
                    if (terminal != null) {
                        if (consumers.remove(consumer)) {
                            consumer.accept(terminal);
                        }
                        return () -> {};
                    }
                    if (!connect.getAndSet(true)) {
                        ((PushStream)builder.build()).forEachEvent(new MultiplexingConsumer(terminalEvent, consumers));
                    }
                    return () -> {
                        if (consumers.remove(consumer)) {
                            try {
                                consumer.accept(PushEvent.close());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    };
                };
            }
        };
    }

    public <T> SimplePushEventSource<T> createSimpleEventSource(Class<T> type) {
        return this.createSimplePushEventSource(1, null, new ArrayBlockingQueue(32), QueuePolicyOption.FAIL.getPolicy(), () -> {});
    }

    public <T, U extends BlockingQueue<PushEvent<? extends T>>> BufferBuilder<SimplePushEventSource<T>, T, U> buildSimpleEventSource(Class<T> type) {
        return new AbstractBufferBuilder<SimplePushEventSource<T>, T, U>(){

            @Override
            public SimplePushEventSource<T> build() {
                return PushStreamProvider.this.createSimplePushEventSource(this.concurrency, this.worker, this.buffer, this.bufferingPolicy, () -> {});
            }
        };
    }

    <T, U extends BlockingQueue<PushEvent<? extends T>>> SimplePushEventSource<T> createSimplePushEventSource(int parallelism, Executor executor, U queue, QueuePolicy<T, U> queuePolicy, Runnable onClose) {
        boolean closeExecutorOnClose;
        Executor toUse;
        if (parallelism < 0) {
            throw new IllegalArgumentException("The supplied parallelism cannot be less than zero. It was " + parallelism);
        }
        if (parallelism == 0) {
            parallelism = 1;
        }
        if (executor == null) {
            toUse = Executors.newFixedThreadPool(parallelism);
            closeExecutorOnClose = true;
        } else {
            toUse = Objects.requireNonNull(executor);
            closeExecutorOnClose = false;
        }
        if (queue == null) {
            queue = new ArrayBlockingQueue(32);
        }
        if (queuePolicy == null) {
            queuePolicy = QueuePolicyOption.FAIL.getPolicy();
        }
        SimplePushEventSourceImpl<T, U> spes = new SimplePushEventSourceImpl<T, U>(new PromiseFactory(toUse, this.acquireScheduler()), queuePolicy, queue, parallelism, () -> {
            try {
                onClose.run();
            }
            catch (Exception exception) {}
            if (closeExecutorOnClose) {
                ((ExecutorService)toUse).shutdown();
            }
            this.releaseScheduler();
        });
        return spes;
    }

    public <T> PushEventConsumer<T> createBufferedConsumer(PushEventConsumer<T> delegate) {
        return this.buildBufferedConsumer(delegate).build();
    }

    public <T, U extends BlockingQueue<PushEvent<? extends T>>> BufferBuilder<PushEventConsumer<T>, T, U> buildBufferedConsumer(final PushEventConsumer<T> delegate) {
        return new AbstractBufferBuilder<PushEventConsumer<T>, T, U>(){

            @Override
            public PushEventConsumer<T> build() {
                PushEventPipe pipe = new PushEventPipe();
                PushStreamProvider.this.createStream(pipe, this.concurrency, this.worker, this.timer, this.buffer, this.bufferingPolicy, this.backPressure).forEachEvent(delegate);
                return pipe;
            }
        };
    }

    public <T> PushStream<T> streamOf(Stream<T> items) {
        PushEventSource pes = aec -> {
            AtomicBoolean closed = new AtomicBoolean(false);
            items.mapToLong(i -> {
                try {
                    long returnValue;
                    long l = returnValue = closed.get() ? -1L : aec.accept(PushEvent.data(i));
                    if (returnValue < 0L) {
                        aec.accept(PushEvent.close());
                    }
                    return returnValue;
                }
                catch (Exception e) {
                    try {
                        aec.accept(PushEvent.error(e));
                    }
                    catch (Exception exception) {}
                    return -1L;
                }
            }).filter(i -> i < 0L).findFirst().orElseGet(() -> {
                try {
                    return aec.accept(PushEvent.close());
                }
                catch (Exception exception) {
                    return -1L;
                }
            });
            return () -> closed.set(true);
        };
        return this.createUnbufferedStream(pes, null, null);
    }

    public <T> PushStream<T> streamOf(Executor executor, ScheduledExecutorService scheduler, final Stream<T> items) {
        boolean releaseSchedulerOnClose;
        ScheduledExecutorService timerToUse;
        boolean closeExecutorOnClose;
        Executor workerToUse;
        if (executor == null) {
            workerToUse = Executors.newFixedThreadPool(2);
            closeExecutorOnClose = true;
        } else {
            workerToUse = Objects.requireNonNull(executor);
            closeExecutorOnClose = false;
        }
        if (scheduler == null) {
            timerToUse = this.acquireScheduler();
            releaseSchedulerOnClose = true;
        } else {
            timerToUse = Objects.requireNonNull(scheduler);
            releaseSchedulerOnClose = false;
        }
        UnbufferedPushStreamImpl stream = new UnbufferedPushStreamImpl<T, BlockingQueue<PushEvent<? extends T>>>(this, new PromiseFactory(workerToUse, timerToUse), aec -> () -> {}){

            @Override
            protected boolean begin() {
                if (super.begin()) {
                    Iterator it = items.iterator();
                    this.promiseFactory.executor().execute(() -> this.pushData(it));
                    return true;
                }
                return false;
            }

            private void pushData(Iterator<T> it) {
                while (it.hasNext()) {
                    try {
                        long returnValue;
                        long l = returnValue = this.closed.get() == AbstractPushStreamImpl.State.CLOSED ? -1L : this.handleEvent(PushEvent.data(it.next()));
                        if (returnValue == 0L) continue;
                        if (returnValue < 0L) {
                            this.close();
                            return;
                        }
                        this.promiseFactory.scheduledExecutor().schedule(() -> this.promiseFactory.executor().execute(() -> this.pushData(it)), returnValue, TimeUnit.MILLISECONDS);
                        return;
                    }
                    catch (Exception e) {
                        this.close(PushEvent.error(e));
                    }
                }
                this.close();
            }
        };
        return this.cleanupThreads(closeExecutorOnClose, workerToUse, releaseSchedulerOnClose, stream);
    }

    private static class MultiplexingConsumer<T>
    implements PushEventConsumer<T> {
        private final AtomicReference<PushEvent<T>> terminalEventStore;
        private final CopyOnWriteArrayList<PushEventConsumer<? super T>> consumers;

        public MultiplexingConsumer(AtomicReference<PushEvent<T>> terminalEventStore, CopyOnWriteArrayList<PushEventConsumer<? super T>> consumers) {
            this.terminalEventStore = terminalEventStore;
            this.consumers = consumers;
        }

        @Override
        public long accept(PushEvent<? extends T> event) throws Exception {
            boolean isTerminal = event.isTerminal();
            if (isTerminal) {
                if (!this.terminalEventStore.compareAndSet(null, event.nodata())) {
                    return -1L;
                }
                for (PushEventConsumer<T> pushEventConsumer : this.consumers) {
                    if (!this.consumers.remove(pushEventConsumer)) continue;
                    try {
                        pushEventConsumer.accept(event);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return -1L;
            }
            long maxBP = 0L;
            for (PushEventConsumer pushEventConsumer : this.consumers) {
                try {
                    long tmpBP = pushEventConsumer.accept(event);
                    if (tmpBP < 0L && this.consumers.remove(pushEventConsumer)) {
                        try {
                            pushEventConsumer.accept(PushEvent.close());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                    if (tmpBP <= maxBP) continue;
                    maxBP = tmpBP;
                }
                catch (Exception ex) {
                    if (!this.consumers.remove(pushEventConsumer)) continue;
                    try {
                        pushEventConsumer.accept(PushEvent.error(ex));
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            return maxBP;
        }
    }

    static final class PushEventPipe<T>
    implements PushEventConsumer<T>,
    PushEventSource<T> {
        volatile PushEventConsumer<? super T> delegate;

        PushEventPipe() {
        }

        @Override
        public AutoCloseable open(PushEventConsumer<? super T> pec) throws Exception {
            return () -> {};
        }

        @Override
        public long accept(PushEvent<? extends T> event) throws Exception {
            return this.delegate.accept(event);
        }
    }
}

