/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.eclipse.kura.web.shared.model.KuraBaseModel;

public class GwtWifiWirelessModeModel
extends KuraBaseModel {
    private static final Logger logger = Logger.getLogger(GwtWifiWirelessModeModel.class.getSimpleName());
    private static final long serialVersionUID = -6095963356000494663L;
    public static final String NAME = "name";
    public static final String MODE = "mode";
    public static final String TOOLTIP = "tooltip";

    protected GwtWifiWirelessModeModel() {
    }

    public GwtWifiWirelessModeModel(GwtWifiWirelessMode mode, String name, String tooltip) {
        this.set(MODE, mode.name());
        this.set(NAME, name);
        this.set(TOOLTIP, tooltip);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public GwtWifiWirelessMode getMode() {
        GwtWifiWirelessMode mode = null;
        String modeStr = (String)this.get(MODE);
        try {
            mode = GwtWifiWirelessMode.valueOf(modeStr);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error getting Wifi Wireless Mode.", e);
        }
        return mode;
    }

    public String getTooltip() {
        return (String)this.get(TOOLTIP);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GwtWifiWirelessModeModel)) {
            return false;
        }
        GwtWifiWirelessModeModel other = (GwtWifiWirelessModeModel)obj;
        if (this.getMode() != null ? !this.getMode().equals((Object)other.getMode()) : other.getMode() != null) {
            return false;
        }
        return !(this.getTooltip() != null ? !this.getTooltip().equals(other.getTooltip()) : other.getTooltip() != null);
    }
}

