/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.kura.web.shared.model.KuraBaseModel;

public class GwtLogEntry
extends KuraBaseModel
implements Serializable {
    private static final long serialVersionUID = 8526545631929936271L;
    private int id;

    public void setId(int id) {
        this.id = id;
    }

    public void setSourceLogProviderPid(String sourceLogProviderPid) {
        super.set(LogEntryKeys.SOURCE_LOGPROVIDER_PID.getKey(), sourceLogProviderPid);
    }

    public int getId() {
        return this.id;
    }

    public String getSourceLogProviderPid() {
        return (String)super.get(LogEntryKeys.SOURCE_LOGPROVIDER_PID.getKey());
    }

    public String getSourceRealtimeTimestamp() {
        String time = (String)super.get(LogEntryKeys.SOURCE_TIMESTAMP.getKey());
        try {
            return new Date(Long.parseLong(time.substring(0, 13))).toString();
        }
        catch (Exception exception) {
            return time;
        }
    }

    public String getPid() {
        return (String)super.get(LogEntryKeys.PID.getKey());
    }

    public String getSyslogIdentifier() {
        return (String)super.get(LogEntryKeys.SYSLOG_ID.getKey());
    }

    public String getTransport() {
        return (String)super.get(LogEntryKeys.TRANSPORT.getKey());
    }

    public String getPriority() {
        return (String)super.get(LogEntryKeys.PRIORITY.getKey());
    }

    public String getMessage() {
        return (String)super.get(LogEntryKeys.MESSAGE.getKey());
    }

    public String getStacktrace() {
        String stacktrace = (String)super.get(LogEntryKeys.STACKTRACE.getKey());
        if (stacktrace == null || stacktrace.equals("undefined")) {
            return "";
        }
        return stacktrace;
    }

    public String prettyPrint(boolean includeMoreInfo, boolean includeStacktrace) {
        this.setUnescaped(true);
        StringBuilder prettyEntry = new StringBuilder();
        prettyEntry.append(this.getSourceRealtimeTimestamp());
        prettyEntry.append("\t[priority: ");
        prettyEntry.append(this.getPriority());
        if (includeMoreInfo) {
            prettyEntry.append(" - PID: ");
            prettyEntry.append(this.getPid());
            prettyEntry.append(" - syslog ID: ");
            prettyEntry.append(this.getSyslogIdentifier());
            prettyEntry.append(" - source: ");
            prettyEntry.append(this.getTransport());
        }
        prettyEntry.append("]\nMessage: ");
        prettyEntry.append(this.getMessage());
        if (includeStacktrace && !this.getStacktrace().isEmpty()) {
            prettyEntry.append("\nStacktrace: ");
            prettyEntry.append(this.getStacktrace());
        }
        prettyEntry.append("\n\n");
        return prettyEntry.toString();
    }

    public static enum LogEntryKeys {
        SOURCE_TIMESTAMP("_SOURCE_REALTIME_TIMESTAMP"),
        SOURCE_LOGPROVIDER_PID("SOURCE_LOGPROVIDER_PID"),
        PID("_PID"),
        SYSLOG_ID("SYSLOG_IDENTIFIER"),
        TRANSPORT("_TRANSPORT"),
        PRIORITY("PRIORITY"),
        MESSAGE("MESSAGE"),
        STACKTRACE("STACKTRACE"),
        CODE_LINE("CODE_LINE");

        private String fieldKey;

        private LogEntryKeys(String key) {
            this.fieldKey = key;
        }

        public String getKey() {
            return this.fieldKey;
        }
    }
}

